/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading;

import com.craftingdead.immerse.trading.TradeCancelReason;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.TradeSession;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TradeEventHandler {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TradeRequestManager.getInstance().tick();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TradeRequestManager.getInstance().cleanupPlayer(serverPlayer.m_142081_());
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TradeSession session = TradeRequestManager.getInstance().getTradeSession(serverPlayer.m_142081_());
            if (session != null) {
                session.cancel(TradeCancelReason.PLAYER_DIED);
            }
        }
    }
}

