/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.trading;

import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.trading.TradeRequestManager;
import com.craftingdead.immerse.trading.network.OpenTradeGuiMessage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class TradeCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_PLAYER = new SimpleCommandExceptionType((Message)new TranslatableComponent("trade.error.not_player"));
    private static final SimpleCommandExceptionType ERROR_PLAYER_NOT_FOUND = new SimpleCommandExceptionType((Message)new TranslatableComponent("trade.error.player_not_found"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trade").then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TradeCommand.acceptTrade((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"deny").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TradeCommand.denyTrade((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"test").executes(context -> TradeCommand.testTradeGui((CommandSourceStack)context.getSource())))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TradeCommand.sendTradeRequest((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
    }

    private static int sendTradeRequest(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer requester = source.m_81375_();
        TradeRequestManager manager = TradeRequestManager.getInstance();
        boolean success = manager.sendTradeRequest(requester, target);
        return success ? 1 : 0;
    }

    private static int acceptTrade(CommandSourceStack source, ServerPlayer requester) throws CommandSyntaxException {
        ServerPlayer accepter = source.m_81375_();
        TradeRequestManager manager = TradeRequestManager.getInstance();
        boolean success = manager.acceptTradeRequest(accepter, requester);
        return success ? 1 : 0;
    }

    private static int denyTrade(CommandSourceStack source, ServerPlayer requester) throws CommandSyntaxException {
        ServerPlayer denier = source.m_81375_();
        TradeRequestManager manager = TradeRequestManager.getInstance();
        boolean success = manager.denyTradeRequest(denier, requester);
        return success ? 1 : 0;
    }

    private static int testTradeGui(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenTradeGuiMessage(UUID.randomUUID(), (Component)new TextComponent("Test Player")));
        player.m_6352_((Component)new TextComponent("Opening trade GUI for testing...").m_130940_(ChatFormatting.GREEN), player.m_142081_());
        return 1;
    }
}

