/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.server;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> gameRotation;
    public final ForgeConfigSpec.EnumValue<NametagMode> nametagMode;
    public final ForgeConfigSpec.IntValue hydrateCommandCooldownMinutes;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("server");
        this.gameRotation = builder.translation("options.craftingdeadimmerse.server.game_rotation").defineList("game_rotation", (List)ImmutableList.of(), gameName -> true);
        builder.pop();
        builder.push("gameplay");
        this.nametagMode = builder.translation("options.craftingdeadimmerse.gameplay.nametag_mode").comment(new String[]{"Allows to define how nametags should be shown to the player.", "DEFAULT: Default minecraft behaviour", "LOOK: The player must be looking at another player to see it's nametag", "HIDE_PLAYER: Hide player nametags", "HIDE_ALL: Hide all nametags"}).defineEnum("nametag_mode", (Enum)NametagMode.DEFAULT);
        this.hydrateCommandCooldownMinutes = builder.translation("options.craftingdeadimmerse.gameplay.hydrate_command_cooldown_minutes").comment(new String[]{"Cooldown, in minutes, applied to players using the /hydrate command.", "Set to 0 to disable the cooldown entirely."}).defineInRange("hydrate_command_cooldown_minutes", 30, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static enum NametagMode {
        DEFAULT,
        LOOK,
        HIDE_PLAYER,
        HIDE_ALL;

    }
}

