/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.network;

import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.network.login.AcknowledgeGameMessage;
import com.craftingdead.immerse.network.login.LoginIndexedMessage;
import com.craftingdead.immerse.network.login.SetupGameMessage;
import com.craftingdead.immerse.network.play.AddKillFeedEntryMessage;
import com.craftingdead.immerse.network.play.ChangeGameMessage;
import com.craftingdead.immerse.network.play.DisplayKilledMessage;
import com.craftingdead.immerse.network.play.RegisterLandOwnerMessage;
import com.craftingdead.immerse.network.play.RemoveLandOwnerMessage;
import com.craftingdead.immerse.network.play.SyncGameMessage;
import com.craftingdead.immerse.network.play.SyncLandChunkMessage;
import com.craftingdead.immerse.network.play.SyncLandManagerMessage;
import com.craftingdead.immerse.network.play.SyncLandOwnerMessage;
import com.craftingdead.immerse.trading.network.CancelTradeMessage;
import com.craftingdead.immerse.trading.network.ConfirmTradeMessage;
import com.craftingdead.immerse.trading.network.OpenTradeGuiMessage;
import com.craftingdead.immerse.trading.network.TradeCompletedMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeCurrencyMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeSlotMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NetworkChannel {
    LOGIN(new ResourceLocation("craftingdeadimmerse", "login")){

        @Override
        protected void registerMessages(SimpleChannel simpleChannel) {
            simpleChannel.messageBuilder(SetupGameMessage.class, 0, NetworkDirection.LOGIN_TO_CLIENT).loginIndex(LoginIndexedMessage::getLoginIndex, LoginIndexedMessage::setLoginIndex).encoder(SetupGameMessage::encode).decoder(SetupGameMessage::decode).consumer(HandshakeHandler.biConsumerFor((handler, msg, ctx) -> SetupGameMessage.handle(msg, ctx))).buildLoginPacketList(isLocal -> CraftingDeadImmerse.getInstance().getLogicalServer().generateSetupGameMessage((boolean)isLocal)).add();
            simpleChannel.messageBuilder(AcknowledgeGameMessage.class, 1, NetworkDirection.LOGIN_TO_SERVER).loginIndex(LoginIndexedMessage::getLoginIndex, LoginIndexedMessage::setLoginIndex).encoder(AcknowledgeGameMessage::encode).decoder(AcknowledgeGameMessage::decode).consumer(HandshakeHandler.indexFirst((handler, msg, ctx) -> AcknowledgeGameMessage.handle(msg, ctx))).add();
        }
    }
    ,
    PLAY(new ResourceLocation("craftingdeadimmerse", "play")){

        @Override
        protected void registerMessages(SimpleChannel simpleChannel) {
            simpleChannel.messageBuilder(ChangeGameMessage.class, 0, NetworkDirection.PLAY_TO_CLIENT).encoder(ChangeGameMessage::encode).decoder(ChangeGameMessage::decode).consumer(ChangeGameMessage::handle).add();
            simpleChannel.messageBuilder(DisplayKilledMessage.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder(DisplayKilledMessage::encode).decoder(DisplayKilledMessage::decode).consumer(DisplayKilledMessage::handle).add();
            simpleChannel.messageBuilder(SyncGameMessage.class, 2, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncGameMessage::encode).decoder(SyncGameMessage::decode).consumer(SyncGameMessage::handle).add();
            simpleChannel.messageBuilder(RegisterLandOwnerMessage.class, 3, NetworkDirection.PLAY_TO_CLIENT).encoder(RegisterLandOwnerMessage::encode).decoder(RegisterLandOwnerMessage::decode).consumer(RegisterLandOwnerMessage::handle).add();
            simpleChannel.messageBuilder(RemoveLandOwnerMessage.class, 4, NetworkDirection.PLAY_TO_CLIENT).encoder(RemoveLandOwnerMessage::encode).decoder(RemoveLandOwnerMessage::decode).consumer(RemoveLandOwnerMessage::handle).add();
            simpleChannel.messageBuilder(SyncLandChunkMessage.class, 5, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncLandChunkMessage::encode).decoder(SyncLandChunkMessage::decode).consumer(SyncLandChunkMessage::handle).add();
            simpleChannel.messageBuilder(SyncLandOwnerMessage.class, 6, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncLandOwnerMessage::encode).decoder(SyncLandOwnerMessage::decode).consumer(SyncLandOwnerMessage::handle).add();
            simpleChannel.messageBuilder(SyncLandManagerMessage.class, 7, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncLandManagerMessage::encode).decoder(SyncLandManagerMessage::decode).consumer(SyncLandManagerMessage::handle).add();
            simpleChannel.messageBuilder(AddKillFeedEntryMessage.class, 8, NetworkDirection.PLAY_TO_CLIENT).encoder(AddKillFeedEntryMessage::encode).decoder(AddKillFeedEntryMessage::decode).consumer(AddKillFeedEntryMessage::handle).add();
            simpleChannel.messageBuilder(OpenTradeGuiMessage.class, 9, NetworkDirection.PLAY_TO_CLIENT).encoder(OpenTradeGuiMessage::encode).decoder(OpenTradeGuiMessage::decode).consumer(OpenTradeGuiMessage::handle).add();
            simpleChannel.messageBuilder(UpdateTradeSlotMessage.class, 10, NetworkDirection.PLAY_TO_SERVER).encoder(UpdateTradeSlotMessage::encode).decoder(UpdateTradeSlotMessage::decode).consumer(UpdateTradeSlotMessage::handle).add();
            simpleChannel.messageBuilder(UpdateTradeSlotMessage.class, 11, NetworkDirection.PLAY_TO_CLIENT).encoder(UpdateTradeSlotMessage::encode).decoder(UpdateTradeSlotMessage::decode).consumer(UpdateTradeSlotMessage::handle).add();
            simpleChannel.messageBuilder(UpdateTradeCurrencyMessage.class, 12, NetworkDirection.PLAY_TO_SERVER).encoder(UpdateTradeCurrencyMessage::encode).decoder(UpdateTradeCurrencyMessage::decode).consumer(UpdateTradeCurrencyMessage::handle).add();
            simpleChannel.messageBuilder(UpdateTradeCurrencyMessage.class, 13, NetworkDirection.PLAY_TO_CLIENT).encoder(UpdateTradeCurrencyMessage::encode).decoder(UpdateTradeCurrencyMessage::decode).consumer(UpdateTradeCurrencyMessage::handle).add();
            simpleChannel.messageBuilder(ConfirmTradeMessage.class, 14, NetworkDirection.PLAY_TO_SERVER).encoder(ConfirmTradeMessage::encode).decoder(ConfirmTradeMessage::decode).consumer(ConfirmTradeMessage::handle).add();
            simpleChannel.messageBuilder(CancelTradeMessage.class, 15, NetworkDirection.PLAY_TO_SERVER).encoder(CancelTradeMessage::encode).decoder(CancelTradeMessage::decode).consumer(CancelTradeMessage::handle).add();
            simpleChannel.messageBuilder(CancelTradeMessage.class, 16, NetworkDirection.PLAY_TO_CLIENT).encoder(CancelTradeMessage::encode).decoder(CancelTradeMessage::decode).consumer(CancelTradeMessage::handle).add();
            simpleChannel.messageBuilder(TradeCompletedMessage.class, 17, NetworkDirection.PLAY_TO_CLIENT).encoder(TradeCompletedMessage::encode).decoder(TradeCompletedMessage::decode).consumer(TradeCompletedMessage::handle).add();
        }
    };

    private static final String NETWORK_VERSION = "0.0.1.0";
    private static boolean loaded;
    private final SimpleChannel simpleChannel;

    private NetworkChannel(ResourceLocation channelName) {
        this.simpleChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(NETWORK_VERSION::equals).serverAcceptedVersions(NETWORK_VERSION::equals).networkProtocolVersion(() -> NETWORK_VERSION).simpleChannel();
    }

    protected abstract void registerMessages(SimpleChannel var1);

    public SimpleChannel getSimpleChannel() {
        return this.simpleChannel;
    }

    public static void loadChannels() {
        if (!loaded) {
            for (NetworkChannel channel : NetworkChannel.values()) {
                channel.registerMessages(channel.simpleChannel);
            }
            loaded = true;
        }
    }
}

