/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm.state;

import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import com.craftingdead.immerse.game.tdm.TdmServer;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import com.craftingdead.immerse.util.state.State;
import com.craftingdead.immerse.util.state.TimedStateInstance;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;

public class GameStateInstance
extends TimedStateInstance<TdmServer> {
    private static final Component TIE_GAME = new TextComponent("Tie Game!");
    private static final Component SPACE = new TextComponent(" ");
    private static final Component WON = new TextComponent("Won!");
    private static final Component DEATHMATCH = new TextComponent("Deathmatch");

    public GameStateInstance(State<?> state, TdmServer context) {
        super(state, context, context.getGameDuration());
    }

    @Override
    public boolean tick() {
        if (this.getTimeRemainingSeconds() <= 20L && this.hasSecondPast()) {
            GameUtil.broadcastSound((SoundEvent)ImmerseSoundEvents.COUNTDOWN.get(), ((TdmServer)this.getContext()).getMinecraftServer());
        }
        TeamInstance<TdmTeam> redTeam = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.RED);
        TeamInstance<TdmTeam> blueTeam = ((TdmServer)this.getContext()).getTeamModule().getTeamInstance(TdmTeam.BLUE);
        if (TdmTeam.getScore(redTeam) >= ((TdmServer)this.getContext()).getMaxScore() ^ TdmTeam.getScore(blueTeam) >= ((TdmServer)this.getContext()).getMaxScore()) {
            this.finishGame(redTeam, blueTeam);
            return true;
        }
        if (super.tick()) {
            this.finishGame(redTeam, blueTeam);
            return true;
        }
        return false;
    }

    private void finishGame(TeamInstance<?> redTeam, TeamInstance<?> blueTeam) {
        MutableComponent winnerText;
        TdmTeam winningTeam = ((TdmServer)this.getContext()).getWinningTeam().orElse(null);
        ((TdmServer)this.getContext()).setMovementBlocked(true);
        if (winningTeam == null) {
            winnerText = TIE_GAME.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
            redTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.RED_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
            blueTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.BLUE_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
        } else {
            winnerText = winningTeam.getDisplayName().m_6881_().m_130940_(ChatFormatting.BOLD).m_7220_(SPACE).m_7220_(WON);
            switch (winningTeam) {
                case RED: {
                    redTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.RED_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    blueTeam.broadcastDefeatSounds((SoundEvent)ImmerseSoundEvents.BLUE_DEFEAT.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    break;
                }
                case BLUE: {
                    blueTeam.broadcastVictorySounds((SoundEvent)ImmerseSoundEvents.BLUE_VICTORY.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    redTeam.broadcastDefeatSounds((SoundEvent)ImmerseSoundEvents.RED_DEFEAT.get(), ((TdmServer)this.getContext()).getMinecraftServer());
                    break;
                }
            }
        }
        this.sendWinAnnoucement((Component)winnerText, TdmTeam.getScore(redTeam), TdmTeam.getScore(blueTeam));
    }

    private void sendWinAnnoucement(Component winnerText, int redScore, int blueScore) {
        MutableComponent scores = new TextComponent("Red: " + redScore + "    Blue: " + blueScore).m_130944_(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.ITALIC});
        GameUtil.sendChatAnnouncement(DEATHMATCH, (Component)winnerText.m_6881_().m_7220_(GameUtil.NEW_LINE).m_7220_((Component)scores), ((TdmServer)this.getContext()).getMinecraftServer());
    }
}

