/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.module.team.ServerTeamModule;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmServer;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.DisplayKilledMessage;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.network.PacketDistributor;

public class TdmServerPlayerHandler
extends TdmPlayerHandler<ServerPlayer> {
    private static final float ASSIST_DAMAGE_PCT = 0.4f;
    private int secondTicker;
    private Player lastSignificantDamage;
    private boolean wasGhost;
    private boolean ghost;
    private ServerPlayer pendingSpectate;
    private TdmServer game;
    private boolean valid = true;

    public TdmServerPlayerHandler(TdmServer game, PlayerExtension<ServerPlayer> player) {
        super(game, player, (int)game.getBuyDuration().getSeconds(), (int)game.getSpawnProtectionDuration().getSeconds(), (int)game.getGhostDuration().getSeconds());
        this.game = game;
    }

    public void resetBuyTime() {
        this.setRemainingBuyTimeSeconds((int)this.game.getBuyDuration().getSeconds());
    }

    public void tick() {
        super.tick();
        if (this.wasGhost != this.ghost) {
            this.wasGhost = this.ghost;
            this.getPlayerData().setDead(this.ghost);
        }
        if (this.ghost && this.pendingSpectate != null) {
            if (this.pendingSpectate.m_6084_() && !this.pendingSpectate.m_5833_()) {
                ((ServerPlayer)this.getPlayer().entity()).m_9213_((Entity)this.pendingSpectate);
            }
            this.pendingSpectate = null;
        }
        if (this.secondTicker++ == 20) {
            this.secondTicker = 0;
            if (this.ghost) {
                if ((Integer)this.dataManager.compute(REMAINING_GHOST_TIME_SECONDS, ghostTime -> {
                    ghostTime = ghostTime - 1;
                    return ghostTime;
                }) <= 0) {
                    this.ghost = false;
                    ((ServerPlayer)this.getPlayer().entity()).m_143403_(GameType.ADVENTURE);
                    this.game.getLogicalServer().respawnPlayer((ServerPlayer)this.getPlayer().entity(), false);
                }
            } else if (!((ServerPlayer)this.getPlayer().entity()).m_5833_()) {
                this.dataManager.compute(REMAINING_BUY_TIME_SECONDS, buyTime -> buyTime > 0 ? (buyTime = Integer.valueOf(buyTime - 1)) : buyTime);
                this.dataManager.compute(REMAINING_SPAWN_PROTECTION_SECONDS, spawnProtection -> {
                    int n;
                    if (spawnProtection > 0) {
                        Integer n2;
                        spawnProtection = spawnProtection - 1;
                        if ((float)n2.intValue() < (float)this.game.getSpawnProtectionDuration().getSeconds() * 0.8f && this.getPlayer().isMoving()) {
                            n = 0;
                            return n;
                        }
                    }
                    n = spawnProtection;
                    return n;
                });
            }
        }
    }

    public boolean handleHurt(DamageSource source, float amount) {
        if (this.getRemainingSpawnProtectionSeconds() > 0 || this.isMovementBlocked()) {
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_().m_41619_()) {
                return true;
            }
            if (amount > ((ServerPlayer)this.getPlayer().entity()).m_21233_() * 0.4f) {
                this.lastSignificantDamage = player;
            }
            if (player.getCapability(LivingExtension.CAPABILITY).resolve().flatMap(e -> e.getHandler(TYPE)).map(extension -> extension.getTeam().orElse(null) == this.getTeam().orElse(null)).orElse(false).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public boolean handleKill(Entity target) {
        if (target instanceof ServerPlayer) {
            TdmPlayerData playerData = this.getPlayerData();
            playerData.incrementKills();
            playerData.incrementScore();
            this.getTeam().map(((ServerTeamModule)this.game.getTeamModule())::getTeamInstance).ifPresent(TdmTeam::incrementScore);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)target), (Object)new DisplayKilledMessage(((ServerPlayer)this.getPlayer().entity()).m_142049_(), ((ServerPlayer)this.getPlayer().entity()).m_21205_()));
        }
        return false;
    }

    public boolean handleDeath(DamageSource cause) {
        this.getPlayerData().incrementDeaths();
        if (this.lastSignificantDamage != null && this.lastSignificantDamage != cause.m_7639_()) {
            this.game.getPlayerData(this.lastSignificantDamage.m_142081_()).incrementAssists();
        }
        this.ghost = true;
        ServerPlayer player = (ServerPlayer)this.getPlayer().entity();
        player.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
        player.m_143403_(GameType.SPECTATOR);
        if (cause.m_7639_() instanceof ServerPlayer) {
            this.pendingSpectate = (ServerPlayer)cause.m_7639_();
        }
        return false;
    }

    public void copyFrom(PlayerExtension<ServerPlayer> that, boolean wasDeath) {
        TdmServerPlayerHandler extension = (TdmServerPlayerHandler)that.getHandlerOrThrow(TYPE);
        if (extension.valid) {
            this.wasGhost = extension.wasGhost;
            this.ghost = extension.ghost;
            this.pendingSpectate = extension.pendingSpectate;
        }
    }

    public void invalidate() {
        this.valid = false;
    }
}

