/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.entity.extension.Visibility;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;

public class TdmPlayerHandler<P extends Player>
implements PlayerHandler {
    public static final LivingHandlerType<TdmPlayerHandler<?>> TYPE = new LivingHandlerType(new ResourceLocation("craftingdeadimmerse", "tdm_player"));
    protected static final EntityDataAccessor<Integer> REMAINING_BUY_TIME_SECONDS = new EntityDataAccessor(0, EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> REMAINING_SPAWN_PROTECTION_SECONDS = new EntityDataAccessor(2, EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> REMAINING_GHOST_TIME_SECONDS = new EntityDataAccessor(3, EntityDataSerializers.f_135028_);
    private final PlayerExtension<P> player;
    protected final SynchedData dataManager = new SynchedData();
    private final TdmGame game;

    public TdmPlayerHandler(TdmGame game, PlayerExtension<P> player) {
        this(game, player, 0, 0, 0);
    }

    public TdmPlayerHandler(TdmGame game, PlayerExtension<P> player, int buyTimeSeconds, int spawnProtectionSeconds, int ghostTimeSeconds) {
        this.game = game;
        this.player = player;
        this.dataManager.register(REMAINING_BUY_TIME_SECONDS, (Object)buyTimeSeconds);
        this.dataManager.register(REMAINING_SPAWN_PROTECTION_SECONDS, (Object)spawnProtectionSeconds);
        this.dataManager.register(REMAINING_GHOST_TIME_SECONDS, (Object)ghostTimeSeconds);
    }

    public PlayerExtension<P> getPlayer() {
        return this.player;
    }

    public Optional<TdmTeam> getTeam() {
        return this.game.getTeamModule().getPlayerTeam(((Player)this.player.entity()).m_142081_());
    }

    public int getRemainingBuyTimeSeconds() {
        return (Integer)this.dataManager.get(REMAINING_BUY_TIME_SECONDS);
    }

    public void setRemainingBuyTimeSeconds(int remainingBuyTimeSeconds) {
        this.dataManager.set(REMAINING_BUY_TIME_SECONDS, (Object)remainingBuyTimeSeconds);
    }

    public int getRemainingSpawnProtectionSeconds() {
        return (Integer)this.dataManager.get(REMAINING_SPAWN_PROTECTION_SECONDS);
    }

    public void setRemainingSpawnProtectionSeconds(int spawnProtectionSeconds) {
        this.dataManager.set(REMAINING_SPAWN_PROTECTION_SECONDS, (Object)spawnProtectionSeconds);
    }

    public Visibility getVisibility() {
        return this.getRemainingSpawnProtectionSeconds() > 0 ? Visibility.PARTIALLY_VISIBLE : Visibility.VISIBLE;
    }

    public TdmPlayerData getPlayerData() {
        return this.game.getPlayerData(((Player)this.player.entity()).m_142081_());
    }

    public boolean isMovementBlocked() {
        return this.game.isMovementBlocked();
    }

    public boolean isCombatModeEnabled() {
        return true;
    }

    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops, int lootingLevel) {
        return true;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (FriendlyByteBuf)out);
    }

    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

