/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.CombatPickupEvent;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.OpenEquipmentMenuEvent;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.GameTypes;
import com.craftingdead.immerse.game.module.team.TeamModule;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class TdmGame
implements Game {
    private static final EntityDataAccessor<Boolean> MOVEMENT_BLOCKED = new EntityDataAccessor(0, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIMER_VALUE_SECONDS = new EntityDataAccessor(1, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GAME_STATE_ORDINAL = new EntityDataAccessor(2, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DISPLAY_NAME = new EntityDataAccessor(3, EntityDataSerializers.f_135030_);
    private final SynchedData data = new SynchedData();
    private final Map<UUID, TdmPlayerData> playerData = new Object2ObjectOpenHashMap();
    private final Map<UUID, TdmPlayerData> dirtyPlayerData = new Object2ObjectOpenHashMap();

    public TdmGame(String displayName) {
        this.data.register(MOVEMENT_BLOCKED, (Object)false);
        this.data.register(TIMER_VALUE_SECONDS, (Object)0);
        this.data.register(GAME_STATE_ORDINAL, (Object)0);
        this.data.register(DISPLAY_NAME, (Object)displayName);
    }

    public abstract TeamModule<TdmTeam> getTeamModule();

    @Override
    public void load() {
        this.getTeamModule().registerTeam(TdmTeam.RED);
        this.getTeamModule().registerTeam(TdmTeam.BLUE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void unload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public boolean disableBlockBurning() {
        return true;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.data.getAll() : this.data.packDirty()), (FriendlyByteBuf)out);
        Set<Map.Entry<UUID, TdmPlayerData>> playerDataCollection = writeAll ? this.playerData.entrySet() : this.dirtyPlayerData.entrySet();
        out.m_130130_(playerDataCollection.size());
        for (Map.Entry<UUID, TdmPlayerData> entry : playerDataCollection) {
            out.m_130077_(entry.getKey());
            TdmPlayerData playerData = entry.getValue();
            if (playerData == null) {
                out.writeBoolean(true);
                continue;
            }
            out.writeBoolean(false);
            playerData.encode(out, writeAll);
        }
        if (!writeAll) {
            this.dirtyPlayerData.clear();
        }
    }

    public void decode(FriendlyByteBuf in) {
        this.data.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
        int playerDataSize = in.m_130242_();
        for (int i = 0; i < playerDataSize; ++i) {
            UUID playerId = in.m_130259_();
            if (in.readBoolean()) {
                this.playerData.remove(playerId);
                continue;
            }
            this.getPlayerData(playerId).decode(in);
        }
    }

    public boolean requiresSync() {
        return this.data.isDirty() || !this.dirtyPlayerData.isEmpty();
    }

    @SubscribeEvent
    public void handleCombatPickup(CombatPickupEvent event) {
        if (event.getCombatSlot() == null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleGunInitialize(GunEvent.Initialize event) {
        RefillableAmmoProvider ammoProvider = new RefillableAmmoProvider(event.getGun().getDefaultMagazineStack(), 3, true);
        event.setAmmoProvider((AmmoProvider)ammoProvider);
        Item item = event.getItemStack().m_41720_();
        if (item == ModItems.AWP.get() || item == ModItems.M107.get() || item == ModItems.AS50.get()) {
            event.addAttachment((Attachment)Attachments.LP_SCOPE.get());
        }
    }

    @SubscribeEvent
    public void handleOpenEquipmentMenu(OpenEquipmentMenuEvent event) {
        event.setCanceled(true);
    }

    public Optional<TdmTeam> getWinningTeam() {
        int blueScore;
        int redScore = TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.RED));
        if (redScore == (blueScore = TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.BLUE)))) {
            return Optional.empty();
        }
        return Optional.of(redScore > blueScore ? TdmTeam.RED : TdmTeam.BLUE);
    }

    public boolean isMovementBlocked() {
        return (Boolean)this.data.get(MOVEMENT_BLOCKED);
    }

    public void setMovementBlocked(boolean movementBlocked) {
        this.data.set(MOVEMENT_BLOCKED, (Object)movementBlocked);
    }

    public int getTimerValueSeconds() {
        return (Integer)this.data.get(TIMER_VALUE_SECONDS);
    }

    public void setTimerValueSeconds(int timerValueSeconds) {
        this.data.set(TIMER_VALUE_SECONDS, (Object)timerValueSeconds);
    }

    public TdmState getGameState() {
        return TdmState.values()[(Integer)this.data.get(GAME_STATE_ORDINAL)];
    }

    public void setGameState(TdmState gameState) {
        this.data.set(GAME_STATE_ORDINAL, (Object)gameState.ordinal());
    }

    public String getDisplayName() {
        return (String)this.data.get(DISPLAY_NAME);
    }

    protected void setDisplayName(String displayName) {
        this.data.set(DISPLAY_NAME, (Object)displayName);
    }

    public TdmPlayerData getPlayerData(UUID playerId) {
        return this.playerData.computeIfAbsent(playerId, __ -> new TdmPlayerData(playerData -> this.dirtyPlayerData.put(playerId, (TdmPlayerData)playerData)));
    }

    public void deletePlayerData(UUID playerId) {
        this.playerData.remove(playerId);
        this.dirtyPlayerData.put(playerId, null);
    }

    @Override
    public GameType getType() {
        return (GameType)((Object)GameTypes.TEAM_DEATHMATCH.get());
    }
}

