/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.tdm;

import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.SelectTeamScreen;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.shop.ClientShopModule;
import com.craftingdead.immerse.game.module.team.ClientTeamModule;
import com.craftingdead.immerse.game.module.team.TeamModule;
import com.craftingdead.immerse.game.tdm.TdmGame;
import com.craftingdead.immerse.game.tdm.TdmPlayerData;
import com.craftingdead.immerse.game.tdm.TdmPlayerHandler;
import com.craftingdead.immerse.game.tdm.TdmTeam;
import com.craftingdead.immerse.game.tdm.state.TdmState;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TdmClient
extends TdmGame
implements GameClient {
    private static final ResourceLocation STOPWATCH = new ResourceLocation("craftingdeadimmerse", "textures/gui/stopwatch.png");
    private static final ResourceLocation BANNER_INVERTED = new ResourceLocation("craftingdeadimmerse", "textures/gui/banner_inverted.png");
    private static final ResourceLocation DEAD = new ResourceLocation("craftingdeadimmerse", "textures/gui/dead.png");
    private Minecraft minecraft;
    private ClientShopModule shopModule;
    private ClientTeamModule<TdmTeam> teamModule;
    private TdmState lastGameState;
    private boolean sentInitialTeamRequest = false;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public TdmClient() {
        super("");
    }

    private Component getTimer() {
        int totalSeconds = this.getTimerValueSeconds();
        int mins = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return new TextComponent(mins + ":" + (seconds < 10 ? "0" : "") + seconds).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, switch (this.getGameState()) {
            case TdmState.PRE_GAME -> ChatFormatting.YELLOW;
            case TdmState.GAME -> {
                if (totalSeconds <= 20) {
                    yield ChatFormatting.RED;
                }
            }
            default -> ChatFormatting.WHITE;
        }});
    }

    @Override
    public TeamModule<TdmTeam> getTeamModule() {
        return this.teamModule;
    }

    @Override
    public void registerClientModules(Consumer<GameModule> registrar) {
        this.shopModule = new ClientShopModule();
        registrar.accept(this.shopModule);
        this.teamModule = new ClientTeamModule<TdmTeam>(TdmTeam.class, SelectTeamScreen::new);
        registrar.accept(this.teamModule);
    }

    @Override
    public boolean disableSwapHands() {
        return true;
    }

    @Override
    public void tick() {
        if (this.getGameState() != this.lastGameState && this.getMinecraft().f_91074_ != null && this.getTeamModule().getPlayerTeam(this.getMinecraft().f_91074_.m_142081_()).isPresent()) {
            this.lastGameState = this.getGameState();
            switch (this.getGameState()) {
                case PRE_GAME: {
                    this.getMinecraft().f_91065_.m_93006_();
                    this.getMinecraft().f_91065_.m_168714_((Component)new TranslatableComponent("title.warm_up").m_130940_(ChatFormatting.YELLOW));
                    break;
                }
                case GAME: {
                    this.getMinecraft().f_91065_.m_93006_();
                    this.getMinecraft().f_91065_.m_168714_((Component)new TranslatableComponent("title.game_start").m_130940_(ChatFormatting.AQUA));
                    break;
                }
                case POST_GAME: {
                    this.getMinecraft().f_91065_.m_93006_();
                    this.getMinecraft().f_91065_.m_168714_((Component)new TranslatableComponent("title.game_over").m_130940_(ChatFormatting.RED));
                    break;
                }
            }
        }
        if (!this.sentInitialTeamRequest && this.getMinecraft().f_91073_ != null) {
            this.getMinecraft().m_91152_((Screen)new SelectTeamScreen());
            this.sentInitialTeamRequest = true;
        }
    }

    @Override
    public boolean renderOverlay(PlayerExtension<? extends AbstractClientPlayer> player, PoseStack matrixStack, int width, int height, float partialTicks) {
        int middleWidth = width / 2;
        MutableComponent redScore = new TextComponent(String.valueOf(TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.RED)))).m_130948_(TdmTeam.RED.getColourStyle());
        MutableComponent blueScore = new TextComponent(String.valueOf(TdmTeam.getScore(this.getTeamModule().getTeamInstance(TdmTeam.BLUE)))).m_130948_(TdmTeam.BLUE.getColourStyle());
        Component timer = this.getTimer();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(matrixStack, middleWidth - 19, 15.0f, 18.0f, 11.0f, -1728053248);
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (Component)redScore, (int)(middleWidth - 9), (int)17, (int)0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(matrixStack, middleWidth + 1, 15.0f, 18.0f, 11.0f, -1728053248);
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (Component)blueScore, (int)(middleWidth + 10), (int)17, (int)0);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(matrixStack, middleWidth - 19, 1.0f, 38.0f, 13.0f, -1728053248);
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (Component)timer, (int)(middleWidth + 1), (int)4, (int)0);
        int headWidth = 20;
        int headHeight = 20;
        List<UUID> redMembers = this.getTeamModule().getTeamInstance(TdmTeam.RED).getMembers();
        for (int i = 0; i < redMembers.size(); ++i) {
            PlayerInfo playerInfo = this.getMinecraft().m_91403_().m_104949_(redMembers.get(i));
            if (playerInfo == null) continue;
            TdmPlayerData playerData = this.getPlayerData(playerInfo.m_105312_().getId());
            int x = middleWidth - 21 - 20 - i * 23;
            int y = 2;
            RenderUtil.fillWidthHeight(matrixStack, x - 1, y - 1, 22.0f, 22.0f, Integer.MIN_VALUE);
            if (playerData.isDead()) {
                RenderUtil.fillWidthHeight(matrixStack, x, y, 20.0f, 20.0f, Integer.MIN_VALUE);
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)DEAD);
                RenderUtil.blit(matrixStack, x, y, 20.0f, 20.0f);
                RenderSystem.m_69461_();
            } else {
                RenderUtil.blitAvatar(playerInfo.m_105337_(), matrixStack, x, y, 20.0f, 20.0f);
            }
            float f = x - 1;
            float f2 = y + 20 + 2;
            Objects.requireNonNull(this.getMinecraft().f_91062_);
            RenderUtil.fillWidthHeight(matrixStack, f, f2, 22.0f, 9 + 2, Integer.MIN_VALUE);
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (String)String.valueOf(playerData.getScore()), (int)(x + 10), (int)(y + 20 + 4), (int)-1);
        }
        List<UUID> blueMembers = this.getTeamModule().getTeamInstance(TdmTeam.BLUE).getMembers();
        for (int i = 0; i < blueMembers.size(); ++i) {
            PlayerInfo playerInfo = this.getMinecraft().m_91403_().m_104949_(blueMembers.get(i));
            if (playerInfo == null) continue;
            TdmPlayerData playerData = this.getPlayerData(playerInfo.m_105312_().getId());
            int x = middleWidth + 21 + i * 23;
            int y = 2;
            RenderUtil.fillWidthHeight(matrixStack, x - 1, y - 1, 22.0f, 22.0f, Integer.MIN_VALUE);
            if (playerData.isDead()) {
                RenderUtil.fillWidthHeight(matrixStack, x, y, 20.0f, 20.0f, Integer.MIN_VALUE);
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)DEAD);
                RenderUtil.blit(matrixStack, x, y, 20.0f, 20.0f);
                RenderSystem.m_69461_();
            } else {
                RenderUtil.blitAvatar(playerInfo.m_105337_(), matrixStack, x, y, 20.0f, 20.0f);
            }
            float f = x - 1;
            float f3 = y + 20 + 2;
            Objects.requireNonNull(this.getMinecraft().f_91062_);
            RenderUtil.fillWidthHeight(matrixStack, f, f3, 22.0f, 9 + 2, Integer.MIN_VALUE);
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (String)String.valueOf(playerData.getScore()), (int)(x + 10), (int)(y + 20 + 4), (int)-1);
        }
        return false;
    }

    @Override
    public boolean renderPlayerList(PlayerExtension<? extends AbstractClientPlayer> player, PoseStack matrixStack, int width, int height, float partialTicks) {
        int mwidth = width / 2;
        int mheight = height / 2;
        int sbwidth = 330;
        int sbheight = 200;
        int sbx = mwidth - sbwidth / 2;
        int sby = mheight - sbheight / 2 - 18;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby, sbwidth, 40.0f, -872415232);
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby + 3, sbwidth, 34.0f, 0x33FFFFFF);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)BANNER_INVERTED);
        RenderUtil.blit(matrixStack, sbx + 2, sby + 5, 125.0f, 27.5f);
        RenderSystem.m_69461_();
        MutableComponent gameTitle = this.getType().getDisplayName().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
        this.getMinecraft().f_91062_.m_92763_(matrixStack, (Component)gameTitle, (float)(sbx + sbwidth - 3 - this.getMinecraft().f_91062_.m_92852_((FormattedText)gameTitle)), (float)(sby + 9), 0);
        MutableComponent mapTitle = new TextComponent(this.getDisplayName()).m_130940_(ChatFormatting.GRAY);
        this.getMinecraft().f_91062_.m_92763_(matrixStack, (Component)mapTitle, (float)(sbx + sbwidth - 3 - this.getMinecraft().f_91062_.m_92852_((FormattedText)mapTitle)), (float)(sby + 20), 0);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)STOPWATCH);
        RenderUtil.blit(matrixStack, sbx + sbwidth / 2 - 8, sby + 5, 16.0f, 16.0f);
        RenderSystem.m_69461_();
        Component timer = this.getTimer();
        GuiComponent.m_93215_((PoseStack)matrixStack, (Font)this.getMinecraft().f_91062_, (Component)timer, (int)(sbx + sbwidth / 2), (int)(sby + 24), (int)0);
        RenderUtil.fillWidthHeight(matrixStack, sbx, sby + 41, sbwidth, 193.0f, Integer.MIN_VALUE);
        RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 41, sbwidth, 13, (Component)new TextComponent("Ping"), (Component)new TextComponent("Username"), new Component[]{new TextComponent("K"), new TextComponent("A"), new TextComponent("D"), new TextComponent("Score")});
        List<UUID> blueMembers = this.getTeamModule().getTeamInstance(TdmTeam.BLUE).getMembers();
        for (int i = 0; i < blueMembers.size(); ++i) {
            PlayerInfo playerInfo = this.getMinecraft().m_91403_().m_104949_(blueMembers.get(i));
            if (playerInfo == null) continue;
            TextComponent username = playerInfo.m_105342_() == null ? new TextComponent(playerInfo.m_105312_().getName()) : playerInfo.m_105342_();
            TdmPlayerData playerData = this.getPlayerData(playerInfo.m_105312_().getId());
            RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 55 + i * 11, sbwidth, 10, (Component)new TextComponent(String.valueOf(playerInfo.m_105330_())), (Component)username, new Component[]{new TextComponent(String.valueOf(playerData.getKills())), new TextComponent(String.valueOf(playerData.getAssists())), new TextComponent(String.valueOf(playerData.getDeaths())), new TextComponent(String.valueOf(playerData.getScore()))});
        }
        List<UUID> redMembers = this.getTeamModule().getTeamInstance(TdmTeam.RED).getMembers();
        for (int i = 0; i < redMembers.size(); ++i) {
            PlayerInfo playerInfo = this.getMinecraft().m_91403_().m_104949_(redMembers.get(i));
            if (playerInfo == null) continue;
            TextComponent username = playerInfo.m_105342_() == null ? new TextComponent(playerInfo.m_105312_().getName()) : playerInfo.m_105342_();
            TdmPlayerData playerData = this.getPlayerData(playerInfo.m_105312_().getId());
            RenderUtil.renderPlayerListRow(matrixStack, sbx, sby + 147 + i * 11, sbwidth, 10, (Component)new TextComponent(String.valueOf(playerInfo.m_105330_())), (Component)username, new Component[]{new TextComponent(String.valueOf(playerData.getKills())), new TextComponent(String.valueOf(playerData.getAssists())), new TextComponent(String.valueOf(playerData.getDeaths())), new TextComponent(String.valueOf(playerData.getScore()))});
        }
        RenderUtil.fillWidthHeight(matrixStack, sbx + 4, sby + 144, sbwidth - 8, 1.0f, -2130706433);
        return true;
    }

    @SubscribeEvent
    public void handleLivingLoad(LivingExtensionEvent.Load event) {
        PlayerExtension player;
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension && (player = (PlayerExtension)livingExtension).level().m_5776_()) {
            player.registerHandler(TdmPlayerHandler.TYPE, new TdmPlayerHandler(this, player));
        }
    }

    @SubscribeEvent
    public void handleRenderNameplate(RenderNameplateEvent event) {
        TdmTeam ourTeam;
        TdmTeam playerTeam;
        if (event.getEntity() instanceof Player && this.getMinecraft().f_91074_ instanceof Player && (playerTeam = (TdmTeam)this.getTeamModule().getPlayerTeam(event.getEntity().m_142081_()).orElse(null)) != (ourTeam = (TdmTeam)this.getTeamModule().getPlayerTeam(this.getMinecraft().m_91288_().m_142081_()).orElse(null))) {
            event.setResult(Event.Result.DENY);
        }
    }
}

