/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.game.GameServer;
import com.craftingdead.immerse.game.PlayerRemovalReason;
import com.craftingdead.immerse.game.survival.SurvivalGame;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.craftingdead.immerse.game.survival.ThirstSettings;
import com.craftingdead.immerse.world.effect.ImmerseMobEffects;
import com.craftingdead.immerse.world.item.hydration.Hydration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class SurvivalServer
extends SurvivalGame
implements GameServer {
    public static final Codec<SurvivalServer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ThirstSettings.CODEC.optionalFieldOf("thirst").forGetter(SurvivalServer::getThirstSettings), (App)Codec.BOOL.fieldOf("kill_feed_enabled").forGetter(SurvivalServer::killFeedEnabled)).apply((Applicative)instance, SurvivalServer::new));
    @Nullable
    private final ThirstSettings thirstSettings;
    private final boolean killFeedEnabled;

    public SurvivalServer(Optional<ThirstSettings> thirstSettings, boolean killFeedEnabled) {
        super(thirstSettings.isPresent());
        this.thirstSettings = thirstSettings.orElse(null);
        this.killFeedEnabled = killFeedEnabled;
    }

    public Optional<ThirstSettings> getThirstSettings() {
        return Optional.ofNullable(this.thirstSettings);
    }

    @Override
    public boolean persistPlayerData() {
        return true;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public boolean persistGameData() {
        return true;
    }

    @Override
    public boolean killFeedEnabled() {
        return this.killFeedEnabled;
    }

    @SubscribeEvent
    public void handleLivingExtensionLoad(LivingExtensionEvent.Load event) {
        PlayerExtension player;
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension && !(player = (PlayerExtension)livingExtension).level().m_5776_()) {
            player.registerHandler(SurvivalPlayerHandler.TYPE, (LivingHandler)new SurvivalPlayerHandler(this, player));
        }
    }

    @Override
    public void removePlayer(PlayerExtension<ServerPlayer> player, PlayerRemovalReason reason) {
        if (reason.isGameUnloaded()) {
            player.removeHandler(SurvivalPlayerHandler.TYPE);
        }
    }

    @SubscribeEvent
    public void handleUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        event.getItem().getCapability(Hydration.CAPABILITY).map(hydration -> hydration.getWater(event.getItem())).ifPresent(hydration -> event.getEntityLiving().m_7292_(new MobEffectInstance((MobEffect)ImmerseMobEffects.HYDRATE.get(), 1, hydration.intValue())));
    }

    @SubscribeEvent
    public void handleAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item == Items.f_42589_) {
            event.addCapability(Hydration.CAPABILITY_KEY, CapabilityUtil.provider(() -> Hydration.POTION, (Capability[])new Capability[]{Hydration.CAPABILITY}));
            return;
        }
        int water = item == Items.f_42410_ || item == Items.f_42699_ ? 2 : (item == Items.f_42619_ || item == Items.f_42732_ || item == Items.f_42787_ ? 1 : (item == Items.f_42730_ || item == Items.f_42780_ ? 3 : (item == Items.f_42437_ || item == Items.f_42436_ || item == Items.f_42400_ || item == Items.f_42718_ || item == Items.f_42734_ || item == Items.f_42575_ ? 5 : (item == Items.f_42677_ ? 6 : -1))));
        if (water != -1) {
            event.addCapability(Hydration.CAPABILITY_KEY, CapabilityUtil.provider(() -> Hydration.fixed(water), (Capability[])new Capability[]{Hydration.CAPABILITY}));
        }
    }
}

