/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.immerse.event.WaterDecayEvent;
import com.craftingdead.immerse.game.survival.SurvivalGame;
import com.craftingdead.immerse.game.survival.SurvivalServer;
import com.craftingdead.immerse.game.survival.ThirstSettings;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.AddKillFeedEntryMessage;
import com.craftingdead.immerse.world.ImmerseDamageSource;
import com.craftingdead.immerse.world.KillFeedEntry;
import com.craftingdead.immerse.world.level.extension.LegacyBase;
import com.craftingdead.immerse.world.level.extension.LevelExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class SurvivalPlayerHandler
implements PlayerHandler {
    public static final LivingHandlerType<SurvivalPlayerHandler> TYPE = new LivingHandlerType(new ResourceLocation("craftingdeadimmerse", "survival_player"));
    private static final EntityDataAccessor<Integer> DAYS_SURVIVED = new EntityDataAccessor(0, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ZOMBIES_KILLED = new EntityDataAccessor(1, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PLAYERS_KILLED = new EntityDataAccessor(2, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> BASE_ID = new EntityDataAccessor(3, EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> WATER = new EntityDataAccessor(4, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_WATER = new EntityDataAccessor(5, EntityDataSerializers.f_135028_);
    private final SurvivalGame game;
    private final PlayerExtension<?> player;
    private final SynchedData dataManager = new SynchedData();
    private int waterTicks;

    public SurvivalPlayerHandler(SurvivalGame game, PlayerExtension<?> player) {
        this.game = game;
        this.player = player;
        this.dataManager.register(DAYS_SURVIVED, (Object)0);
        this.dataManager.register(ZOMBIES_KILLED, (Object)0);
        this.dataManager.register(PLAYERS_KILLED, (Object)0);
        this.dataManager.register(BASE_ID, Optional.empty());
        this.dataManager.register(WATER, (Object)20);
        this.dataManager.register(MAX_WATER, (Object)20);
    }

    public Optional<LegacyBase> getBase() {
        return this.getBaseId().map(baseId -> LevelExtension.getOrThrow(this.player.level()).getLandManager().getLandOwner((UUID)baseId)).map(LegacyBase.class::cast);
    }

    public Optional<UUID> getBaseId() {
        return (Optional)this.dataManager.get(BASE_ID);
    }

    public void setBaseId(@Nullable UUID baseId) {
        this.dataManager.set(BASE_ID, Optional.ofNullable(baseId));
    }

    public void tick() {
        LivingEntity livingEntity = this.player.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            int aliveTicks = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
            this.setDaysSurvived(aliveTicks / 20 / 60 / 20);
        }
    }

    public void playerTick() {
        SurvivalGame survivalGame = this.game;
        if (survivalGame instanceof SurvivalServer) {
            SurvivalServer server = (SurvivalServer)survivalGame;
            server.getThirstSettings().ifPresent(this::updateThirst);
        }
    }

    private void updateThirst(ThirstSettings settings) {
        Player entity = (Player)this.player.entity();
        if (entity.m_183503_().m_46791_() != Difficulty.PEACEFUL && !entity.m_150110_().f_35934_) {
            ++this.waterTicks;
            if (this.getWater() <= 0) {
                if (this.waterTicks >= settings.damageIntervalTicks() && this.getWater() == 0) {
                    entity.m_6469_(ImmerseDamageSource.DEHYDRATION, 1.0f);
                    this.waterTicks = 0;
                }
            } else if (this.waterTicks >= settings.decayIntervalTicks()) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new WaterDecayEvent((Player)this.player.entity()))) {
                    this.setWater(this.getWater() - settings.decayAmountFor((Entity)entity));
                }
                this.waterTicks = 0;
            }
        }
    }

    public boolean handleKill(Entity target) {
        if (target instanceof Zombie) {
            this.setZombiesKilled(this.getZombiesKilled() + 1);
        } else if (target instanceof ServerPlayer) {
            this.setPlayersKilled(this.getPlayersKilled() + 1);
        }
        return false;
    }

    public boolean handleDeath(DamageSource cause) {
        Entity attackItemEntity = cause.m_7640_();
        Entity attacker = cause.m_7639_();
        LivingEntity entityPlayer = this.player.entity();
        if (attacker != null && attacker.m_20149_().equalsIgnoreCase(entityPlayer.m_20149_())) {
            if (attackItemEntity instanceof Grenade) {
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(new KillFeedEntry(entityPlayer, (Entity)entityPlayer, new ItemStack((ItemLike)ModItems.FRAG_GRENADE.get()), KillFeedEntry.Type.GRENADE)));
            } else {
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(new KillFeedEntry(entityPlayer, (Entity)entityPlayer, this.player.mainHandItem(), KillFeedEntry.Type.SUICIDE)));
            }
        }
        if (cause == ImmerseDamageSource.DEHYDRATION || cause == ImmerseDamageSource.HUNGER) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(new KillFeedEntry(entityPlayer, (Entity)entityPlayer, this.player.mainHandItem(), cause == ImmerseDamageSource.DEHYDRATION ? KillFeedEntry.Type.DEHYDRATION : KillFeedEntry.Type.HUNGER)));
        }
        if (cause == DamageSource.f_19315_) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(new KillFeedEntry(entityPlayer, (Entity)entityPlayer, this.player.mainHandItem(), KillFeedEntry.Type.FALL)));
        }
        return super.handleDeath(cause);
    }

    public int getDaysSurvived() {
        return (Integer)this.dataManager.get(DAYS_SURVIVED);
    }

    public void setDaysSurvived(int daysSurvived) {
        this.dataManager.set(DAYS_SURVIVED, (Object)daysSurvived);
    }

    public int getZombiesKilled() {
        return (Integer)this.dataManager.get(ZOMBIES_KILLED);
    }

    public void setZombiesKilled(int zombiesKilled) {
        this.dataManager.set(ZOMBIES_KILLED, (Object)zombiesKilled);
    }

    public int getPlayersKilled() {
        return (Integer)this.dataManager.get(PLAYERS_KILLED);
    }

    public void setPlayersKilled(int playersKilled) {
        this.dataManager.set(PLAYERS_KILLED, (Object)playersKilled);
    }

    public int getWater() {
        return (Integer)this.dataManager.get(WATER);
    }

    public void setWater(int water) {
        this.dataManager.set(WATER, (Object)Mth.m_14045_((int)water, (int)0, (int)this.getMaxWater()));
    }

    public void hydrate() {
        this.setWater(this.getMaxWater());
    }

    public int getMaxWater() {
        return (Integer)this.dataManager.get(MAX_WATER);
    }

    public void setMaxWater(int maxWater) {
        this.dataManager.set(MAX_WATER, (Object)maxWater);
    }

    public boolean isCombatModeEnabled() {
        return false;
    }

    public void copyFrom(PlayerExtension<ServerPlayer> that, boolean wasDeath) {
        if (!wasDeath) {
            that.getHandler(TYPE).ifPresent(handler -> {
                this.setDaysSurvived(handler.getDaysSurvived());
                this.setZombiesKilled(handler.getZombiesKilled());
                this.setPlayersKilled(handler.getPlayersKilled());
                handler.getBaseId().ifPresent(this::setBaseId);
                this.setWater(handler.getWater());
                this.setMaxWater(handler.getMaxWater());
            });
        }
    }

    public boolean handleBlockBreak(BlockPos pos, BlockState block, MutableInt xp) {
        LevelExtension.getOrThrow(this.player.level()).getLandManager().getLandOwnerAt(pos).ifPresent(base -> base.playerRemovedBlock((LivingExtension<?, ?>)this.player, pos));
        return false;
    }

    public boolean handleBlockPlace(BlockSnapshot replacedBlock, BlockState placedBlock, BlockState placedAgainst) {
        LevelExtension.getOrThrow(this.player.level()).getLandManager().getLandOwnerAt(replacedBlock.getPos()).ifPresent(base -> base.playerPlacedBlock((LivingExtension<?, ?>)this.player, replacedBlock.getPos()));
        return false;
    }

    public boolean handleMultiBlockPlace(List<BlockSnapshot> replacedBlocks, BlockState placedBlock, BlockState placedAgainst) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>(replacedBlocks.size());
        for (BlockSnapshot block : replacedBlocks) {
            if (block.getCurrentBlock().m_60713_(block.getReplacedBlock().m_60734_())) continue;
            pos.add(block.getPos());
        }
        BlockPos refBlock = (BlockPos)pos.get(0);
        LevelExtension.getOrThrow(this.player.level()).getLandManager().getLandOwnerAt(refBlock).ifPresent(base -> base.playerPlacedBlock((LivingExtension<?, ?>)this.player, pos.toArray(new BlockPos[0])));
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("zombiesKilled", this.getZombiesKilled());
        tag.m_128405_("playersKilled", this.getPlayersKilled());
        this.getBaseId().ifPresent(baseId -> tag.m_128362_("baseId", baseId));
        tag.m_128405_("water", this.getWater());
        tag.m_128405_("maxWater", this.getMaxWater());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setZombiesKilled(tag.m_128451_("zombiesKilled"));
        this.setPlayersKilled(tag.m_128451_("playersKilled"));
        if (tag.m_128403_("baseId")) {
            this.setBaseId(tag.m_128342_("baseId"));
        }
        this.setWater(tag.m_128451_("water"));
        this.setMaxWater(tag.m_128451_("maxWater"));
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (FriendlyByteBuf)out);
    }

    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }
}

