/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.network.SynchedData;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.GameTypes;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraftforge.common.MinecraftForge;

public abstract class SurvivalGame
implements Game {
    private static final EntityDataAccessor<Boolean> THIRST_ENABLED = new EntityDataAccessor(0, EntityDataSerializers.f_135035_);
    private final SynchedData data = new SynchedData();

    public SurvivalGame(boolean thirstEnabled) {
        this.data.register(THIRST_ENABLED, (Object)thirstEnabled);
    }

    public boolean isThirstEnabled() {
        return (Boolean)this.data.get(THIRST_ENABLED);
    }

    public void setThirstEnabled(boolean thirstEnabled) {
        this.data.set(THIRST_ENABLED, (Object)thirstEnabled);
    }

    @Override
    public boolean disableBlockBurning() {
        return true;
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void unload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void tick() {
    }

    @Override
    public GameType getType() {
        return (GameType)((Object)GameTypes.SURVIVAL.get());
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.data.getAll() : this.data.packDirty()), (FriendlyByteBuf)out);
    }

    public void decode(FriendlyByteBuf in) {
        this.data.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
    }

    public boolean requiresSync() {
        return this.data.isDirty();
    }
}

