/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.survival;

import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.ClientDist;
import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.survival.SurvivalGame;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SurvivalClient
extends SurvivalGame
implements GameClient {
    private static final ResourceLocation DAYS_SURVIVED = new ResourceLocation("craftingdeadimmerse", "textures/gui/days_survived.png");
    private static final ResourceLocation ZOMBIES_KILLED = new ResourceLocation("craftingdeadimmerse", "textures/gui/zombies_killed.png");
    private static final ResourceLocation PLAYERS_KILLED = new ResourceLocation("craftingdeadimmerse", "textures/gui/players_killed.png");
    private static final ResourceLocation ICONS = new ResourceLocation("craftingdeadimmerse", "textures/gui/icons.png");
    private Minecraft minecraft;
    private boolean showStats = true;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public SurvivalClient() {
        super(false);
    }

    @SubscribeEvent
    public void handleLivingExtensionLoad(LivingExtensionEvent.Load event) {
        PlayerExtension player;
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension && (player = (PlayerExtension)livingExtension).level().m_5776_()) {
            player.registerHandler(SurvivalPlayerHandler.TYPE, (LivingHandler)new SurvivalPlayerHandler(this, player));
        }
    }

    @Override
    public boolean renderOverlay(PlayerExtension<? extends AbstractClientPlayer> player, PoseStack poseStack, int width, int height, float partialTick) {
        SurvivalPlayerHandler survivalPlayer = (SurvivalPlayerHandler)player.getHandlerOrThrow(SurvivalPlayerHandler.TYPE);
        if (this.showStats) {
            int y = height / 2;
            int x = 4;
            RenderSystem.m_157456_((int)0, (ResourceLocation)DAYS_SURVIVED);
            RenderUtil.blit((float)x, (float)(y - 20), (float)16.0f, (float)16.0f);
            this.getMinecraft().f_91062_.m_92750_(poseStack, String.valueOf(survivalPlayer.getDaysSurvived()), (float)(x + 20), (float)(y - 16), 0xFFFFFF);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ZOMBIES_KILLED);
            RenderUtil.blit((float)x, (float)y, (float)16.0f, (float)16.0f);
            this.getMinecraft().f_91062_.m_92750_(poseStack, String.valueOf(survivalPlayer.getZombiesKilled()), (float)(x + 20), (float)(y + 4), 0xFFFFFF);
            RenderSystem.m_157456_((int)0, (ResourceLocation)PLAYERS_KILLED);
            RenderUtil.blit((float)x, (float)(y + 20), (float)16.0f, (float)16.0f);
            this.getMinecraft().f_91062_.m_92750_(poseStack, String.valueOf(survivalPlayer.getPlayersKilled()), (float)(x + 20), (float)(y + 24), 0xFFFFFF);
        }
        if (this.getMinecraft().f_91072_.m_105205_() && !player.isCombatModeEnabled() && this.isThirstEnabled() && !((AbstractClientPlayer)player.entity()).m_204029_(FluidTags.f_13131_) && ((AbstractClientPlayer)player.entity()).m_20146_() == ((AbstractClientPlayer)player.entity()).m_6062_()) {
            this.renderWater(player, width, height, (float)survivalPlayer.getWater() / (float)survivalPlayer.getMaxWater(), ICONS);
        }
        return false;
    }

    private void renderWater(PlayerExtension<?> player, int width, int height, float waterPercentage, ResourceLocation resourceLocation) {
        Entity vehicle = ((Player)player.entity()).m_20202_();
        int y = height - 49;
        int x = width / 2 + 91;
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        if (vehicle instanceof LivingEntity) {
            LivingEntity vehicleEntity = (LivingEntity)vehicle;
            float maxHealth = vehicleEntity.m_21233_();
            int healthRows = (int)Math.ceil(maxHealth / 21.0f);
            y -= (healthRows - 1) * 10;
        }
        for (int i = 0; i < 10; ++i) {
            RenderUtil.blit((float)(x - i * 8 - 9), (float)y, (float)9.0f, (float)9.0f, (float)0.0f, (float)32.0f);
            float scaledWater = 10.0f * waterPercentage;
            if ((float)(i + 1) <= scaledWater) {
                RenderUtil.blit((float)(x - i * 8 - 9), (float)y, (float)9.0f, (float)9.0f, (float)9.0f, (float)32.0f);
                continue;
            }
            if (!(scaledWater >= (float)i + 0.5f)) continue;
            RenderUtil.blit((float)(x - i * 8 - 9), (float)y, (float)9.0f, (float)9.0f, (float)18.0f, (float)32.0f);
        }
        RenderSystem.m_69461_();
    }

    @Override
    public void tick() {
        super.tick();
        while (ClientDist.TOGGLE_STATS.m_90859_()) {
            this.showStats = !this.showStats;
        }
    }
}

