/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.team;

import com.craftingdead.core.network.Synched;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.ModuleType;
import com.craftingdead.immerse.game.module.ModuleTypes;
import com.craftingdead.immerse.game.module.team.TeamInstance;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class TeamModule<T extends Enum<T>>
implements GameModule,
Synched {
    private final Class<T> teamType;
    private final Map<T, TeamInstance<T>> teams;
    protected final Map<UUID, T> playerTeams = new HashMap<UUID, T>();
    protected final Map<UUID, T> dirtyPlayerTeams = new HashMap<UUID, T>();

    public TeamModule(Class<T> teamType) {
        this.teamType = teamType;
        this.teams = new EnumMap<T, TeamInstance<T>>(teamType);
    }

    public void registerTeam(T team) {
        this.teams.put(team, new TeamInstance<T>(team));
    }

    public TeamInstance<T> getSmallestTeam() {
        TeamInstance<T> smallestTeam = null;
        for (TeamInstance<T> team : this.teams.values()) {
            if (smallestTeam != null && team.getMembers().size() >= smallestTeam.getMembers().size()) continue;
            smallestTeam = team;
        }
        return smallestTeam;
    }

    public TeamInstance<T> getTeamInstance(T team) {
        return this.teams.get(team);
    }

    public Optional<T> getPlayerTeam(UUID playerId) {
        return Optional.ofNullable((Enum)this.playerTeams.get(playerId));
    }

    @Override
    public ModuleType getType() {
        return (ModuleType)((Object)ModuleTypes.TEAM.get());
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        for (Map.Entry<T, TeamInstance<T>> entry : this.teams.entrySet()) {
            if (!entry.getValue().requiresSync()) continue;
            out.m_130130_(((Enum)entry.getKey()).ordinal());
            entry.getValue().encode(out, false);
        }
        out.m_130130_(-1);
        boolean writePlayerTeams = writeAll || !this.dirtyPlayerTeams.isEmpty();
        out.writeBoolean(writePlayerTeams);
        if (writePlayerTeams) {
            out.writeBoolean(writeAll);
            Map<UUID, T> playerTeamsToSend = writeAll ? this.playerTeams : this.dirtyPlayerTeams;
            out.m_130130_(playerTeamsToSend.size());
            for (Map.Entry<UUID, T> entry : playerTeamsToSend.entrySet()) {
                out.m_130077_(entry.getKey());
                if (entry.getValue() == null) {
                    out.writeBoolean(true);
                    continue;
                }
                out.writeBoolean(false);
                out.m_130068_((Enum)entry.getValue());
            }
        }
        if (!writeAll) {
            this.dirtyPlayerTeams.clear();
        }
    }

    private TeamInstance<T> getExpectedTeamInstance(T team) {
        TeamInstance<T> teamInstance = this.teams.get(team);
        if (teamInstance == null) {
            throw new IllegalStateException("Expected team '" + ((Enum)team).toString() + "' to be present");
        }
        return teamInstance;
    }

    public void decode(FriendlyByteBuf in) {
        int i;
        while ((i = in.m_130242_()) != -1) {
            Enum team = ((Enum[])this.teamType.getEnumConstants())[i];
            this.getExpectedTeamInstance(team).decode(in);
        }
        if (in.readBoolean()) {
            if (in.readBoolean()) {
                this.playerTeams.clear();
            }
            int playerTeamsSize = in.m_130242_();
            for (int j = 0; j < playerTeamsSize; ++j) {
                Enum team;
                UUID playerId = in.m_130259_();
                if (in.readBoolean()) {
                    TeamInstance<Enum> teamInstance;
                    team = (Enum)this.playerTeams.remove(playerId);
                    if (team == null || (teamInstance = this.getTeamInstance(team)) == null) continue;
                    teamInstance.removeMember(playerId);
                    continue;
                }
                team = in.m_130066_(this.teamType);
                Enum oldTeam = this.playerTeams.put(playerId, team);
                if (oldTeam != null) {
                    this.getExpectedTeamInstance(oldTeam).removeMember(playerId);
                }
                this.getExpectedTeamInstance(team).addMember(playerId);
            }
        }
    }

    public boolean requiresSync() {
        return this.teams.values().stream().anyMatch(TeamInstance::requiresSync) || !this.dirtyPlayerTeams.isEmpty();
    }
}

