/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.team;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.immerse.game.module.team.Team;
import com.craftingdead.immerse.sounds.ImmerseSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.common.util.INBTSerializable;

public class TeamInstance<T extends Team>
implements INBTSerializable<CompoundTag>,
Synched {
    protected final SynchedData dataManager = new SynchedData();
    private final T team;
    private final List<UUID> members = new ArrayList<UUID>();

    public TeamInstance(T team) {
        this.team = team;
        this.team.registerDataParameters(this.dataManager);
    }

    public void broadcastVictorySounds(SoundEvent teamVictoryCallout, MinecraftServer minecraftServer) {
        this.forEach(playerEntity -> {
            playerEntity.m_6330_((SoundEvent)ImmerseSoundEvents.VICTORY_MUSIC.get(), SoundSource.MASTER, 0.7f, 1.0f);
            playerEntity.m_6330_(teamVictoryCallout, SoundSource.MASTER, 0.7f, 1.0f);
        }, minecraftServer);
    }

    public void broadcastDefeatSounds(SoundEvent teamDefeatCallout, MinecraftServer minecraftServer) {
        this.forEach(playerEntity -> {
            playerEntity.m_6330_((SoundEvent)ImmerseSoundEvents.DEFEAT_MUSIC.get(), SoundSource.MASTER, 0.7f, 1.0f);
            playerEntity.m_6330_(teamDefeatCallout, SoundSource.MASTER, 0.7f, 1.0f);
        }, minecraftServer);
    }

    public void forEach(Consumer<ServerPlayer> action, MinecraftServer minecraftServer) {
        for (UUID memberId : this.members) {
            action.accept(minecraftServer.m_6846_().m_11259_(memberId));
        }
    }

    void addMember(UUID memberId) {
        this.members.add(memberId);
    }

    void removeMember(UUID memberId) {
        this.members.remove(memberId);
    }

    public SynchedData getDataManager() {
        return this.dataManager;
    }

    public List<UUID> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public T getTeam() {
        return this.team;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack((List)(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty()), (FriendlyByteBuf)out);
    }

    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack((FriendlyByteBuf)in));
    }

    public boolean requiresSync() {
        return this.dataManager.isDirty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.team.save(this, nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.team.load(this, nbt);
    }
}

