/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.immerse.game.module.shop.ShopItem;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public record ShopCategory(Component displayName, Component info, List<ShopItem> items) {
    public void encode(FriendlyByteBuf out) {
        out.m_130083_(this.displayName);
        out.m_130083_(this.info);
        out.m_130130_(this.items.size());
        for (ShopItem item : this.items) {
            out.m_130077_(item.id());
        }
    }

    public static ShopCategory decode(FriendlyByteBuf in, Function<UUID, ShopItem> itemLookup) {
        Component displayName = in.m_130238_();
        Component info = in.m_130238_();
        int categoryItemsSize = in.m_130242_();
        ShopItem[] items = new ShopItem[categoryItemsSize];
        for (int j = 0; j < categoryItemsSize; ++j) {
            UUID itemId = in.m_130259_();
            ShopItem item = itemLookup.apply(itemId);
            if (item == null) {
                throw new IllegalStateException("Unknown item with ID: " + itemId.toString());
            }
            items[j] = item;
        }
        return new ShopCategory(displayName, info, List.of(items));
    }
}

