/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game.module.shop;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.shop.ShopScreen;
import com.craftingdead.immerse.game.GameUtil;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.shop.ShopModule;
import com.craftingdead.immerse.game.module.shop.message.BuyItemMessage;
import com.craftingdead.immerse.game.module.shop.message.SyncUserMessage;
import com.craftingdead.immerse.game.network.GameNetworkChannel;
import com.craftingdead.immerse.game.network.MessageHandlerRegistry;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientShopModule
extends ShopModule
implements GameModule.Tickable {
    private static final MessageHandlerRegistry<ClientShopModule> messageHandlers = new MessageHandlerRegistry();
    private Minecraft minecraft;
    private int buyTimeSeconds;
    private int money;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public void buyItem(UUID itemId) {
        GameNetworkChannel.sendToServer(this.getType(), new BuyItemMessage(itemId));
    }

    public int getBuyTimeSeconds() {
        return this.buyTimeSeconds;
    }

    public boolean canAfford(int amount) {
        return this.money >= amount;
    }

    public int getMoney() {
        return this.money;
    }

    private void handleSyncUser(SyncUserMessage message, NetworkEvent.Context context) {
        this.buyTimeSeconds = message.buyTimeSeconds();
        this.money = message.money();
    }

    @Override
    public <MSG> void handleMessage(MSG message, NetworkEvent.Context context) {
        messageHandlers.handle(this, message, context);
    }

    @Override
    public void tick() {
        while (this.getMinecraft().f_91066_.f_92092_.m_90859_()) {
            if (this.getMinecraft().f_91074_.m_5833_()) continue;
            PlayerExtension player = PlayerExtension.getOrThrow((Player)this.getMinecraft().f_91074_);
            if (this.buyTimeSeconds > 0) {
                this.getMinecraft().m_91152_((Screen)new ShopScreen(null, this, player));
                continue;
            }
            this.getMinecraft().f_91065_.m_93076_().m_93785_(GameUtil.formatMessage((Component)new TranslatableComponent("message.buy_time_expired")));
        }
    }

    static {
        messageHandlers.register(SyncUserMessage.class, ClientShopModule::handleSyncUser);
    }
}

