/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import com.craftingdead.core.network.Synched;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.module.GameModule;
import com.craftingdead.immerse.game.module.ModuleType;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.network.play.SyncGameMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class GameWrapper<T extends Game, M extends GameModule> {
    private final T game;
    protected final Map<IRegistryDelegate<ModuleType>, M> modules;
    private final Collection<GameModule.Tickable> tickableModules;
    private final Map<IRegistryDelegate<ModuleType>, Synched> synched;

    public GameWrapper(T game) {
        this.game = game;
        ModuleBuilder moduleBuilder = new ModuleBuilder();
        this.buildModules(game, moduleBuilder);
        this.modules = moduleBuilder.modules().buildOrThrow();
        this.tickableModules = moduleBuilder.tickables().build();
        this.synched = moduleBuilder.synched().buildOrThrow();
    }

    protected abstract void buildModules(T var1, ModuleBuilder<M> var2);

    public T getGame() {
        return this.game;
    }

    @Nullable
    public M getModule(ModuleType moduleType) {
        return (M)((GameModule)this.modules.get(moduleType.delegate));
    }

    public void load() {
        this.modules.values().forEach(GameModule::load);
        this.game.load();
    }

    public void unload() {
        this.game.unload();
        this.modules.values().forEach(GameModule::unload);
    }

    public void tick() {
        this.tickableModules.forEach(GameModule.Tickable::tick);
        this.game.tick();
    }

    public Packet<?> buildSyncPacket(boolean writeAll) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        this.encode(packetBuffer, writeAll);
        return NetworkChannel.PLAY.getSimpleChannel().toVanillaPacket((Object)new SyncGameMessage(packetBuffer), NetworkDirection.PLAY_TO_CLIENT);
    }

    private void encode(FriendlyByteBuf out, boolean writeAll) {
        this.game.encode(out, writeAll);
        out.m_130130_(this.modules.size());
        for (Map.Entry<IRegistryDelegate<ModuleType>, Synched> entry : this.synched.entrySet()) {
            out.writeRegistryId((IForgeRegistryEntry)((ModuleType)((Object)entry.getKey().get())));
            entry.getValue().encode(out, writeAll);
        }
    }

    public void decode(FriendlyByteBuf in) {
        this.game.decode(in);
        int size = in.m_130242_();
        for (int i = 0; i < size; ++i) {
            ModuleType moduleType = (ModuleType)in.readRegistryIdSafe(ModuleType.class);
            Synched module = this.synched.get(moduleType.delegate);
            if (module == null) {
                throw new IllegalStateException("Module not present with ID: " + moduleType.getRegistryName().toString());
            }
            module.decode(in);
        }
    }

    protected boolean requiresSync() {
        return this.game.requiresSync() || this.synched.values().stream().anyMatch(Synched::requiresSync);
    }

    record ModuleBuilder<M extends GameModule>(ImmutableMap.Builder<IRegistryDelegate<ModuleType>, M> modules, ImmutableList.Builder<GameModule.Tickable> tickables, ImmutableMap.Builder<IRegistryDelegate<ModuleType>, Synched> synched) {
        ModuleBuilder() {
            this(ImmutableMap.builder(), (ImmutableList.Builder<GameModule.Tickable>)ImmutableList.builder(), (ImmutableMap.Builder<IRegistryDelegate<ModuleType>, Synched>)ImmutableMap.builder());
        }

        void registerModule(M module) {
            this.modules.put((Object)module.getType().delegate, module);
            if (module instanceof GameModule.Tickable) {
                GameModule.Tickable tickable = (GameModule.Tickable)module;
                this.tickables.add((Object)tickable);
            }
            if (module instanceof Synched) {
                Synched synched = (Synched)module;
                this.synched.put((Object)module.getType().delegate, (Object)synched);
            }
        }
    }
}

