/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.game;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.lang3.StringUtils;

public class GameUtil {
    private static final String SQUARE_UTF_8 = "\u2588";
    private static final Component CHAT_SEPERATOR = new TextComponent(StringUtils.repeat((String)"\u2588", (int)30));
    public static final Component NEW_LINE = new TextComponent("\n\n");

    public static Component formatMessage(Component message) {
        return new TranslatableComponent("message.game").m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TextComponent(" >>> ").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)0xFFFFFF)))).m_7220_((Component)message.m_6881_().m_130940_(ChatFormatting.GRAY));
    }

    public static void sendGameMessageToAll(Component message, MinecraftServer minecraftServer) {
        minecraftServer.m_6846_().m_11264_(GameUtil.formatMessage(message), ChatType.SYSTEM, Util.f_137441_);
    }

    public static void sendAnnouncement(Component message, MinecraftServer minecraftServer) {
        minecraftServer.m_6846_().m_11268_((Packet)new ClientboundSetTitleTextPacket(message));
    }

    public static void sendChatAnnouncement(Component title, Component body, MinecraftServer minecraftServer) {
        MutableComponent announcement = CHAT_SEPERATOR.m_6881_().m_7220_(NEW_LINE).m_7220_((Component)title.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))).m_7220_(NEW_LINE).m_7220_(body).m_7220_(NEW_LINE).m_7220_(CHAT_SEPERATOR);
        minecraftServer.m_6846_().m_11264_((Component)announcement, ChatType.SYSTEM, Util.f_137441_);
    }

    public static void broadcastSound(SoundEvent soundEvent, MinecraftServer minecraftServer) {
        GameUtil.broadcastSound(soundEvent, minecraftServer, 0.7f, 1.0f);
    }

    public static void broadcastSound(SoundEvent soundEvent, MinecraftServer minecraftServer, float volume, float pitch) {
        minecraftServer.m_6846_().m_11314_().forEach(playerEntity -> playerEntity.m_6330_(soundEvent, SoundSource.MASTER, volume, pitch));
    }
}

