/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.command;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.Permissions;
import com.craftingdead.immerse.command.ImmerseCommands;
import com.craftingdead.immerse.game.Game;
import com.craftingdead.immerse.game.survival.SurvivalGame;
import com.craftingdead.immerse.game.survival.SurvivalPlayerHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;

public class HydrateCommand {
    private static final long TICKS_PER_SECOND = 20L;
    private static final long TICKS_PER_MINUTE = 1200L;
    private static final Map<UUID, Long> COOLDOWNS = new HashMap<UUID, Long>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hydrate").requires(source -> {
            SurvivalGame game;
            Game patt2322$temp;
            return ImmerseCommands.hasPermission(source, Permissions.HYDRATE) && (patt2322$temp = CraftingDeadImmerse.getInstance().getGame(LogicalSide.SERVER)) instanceof SurvivalGame && (game = (SurvivalGame)patt2322$temp).isThirstEnabled();
        })).executes(context -> HydrateCommand.processCommand((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> HydrateCommand.processCommand((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets")))));
    }

    private static int processCommand(CommandSourceStack source, Collection<ServerPlayer> targets) {
        List<PlayerExtension> hydrated;
        Entity entity;
        Integer cooldownMinutes = (Integer)CraftingDeadImmerse.serverConfig.hydrateCommandCooldownMinutes.get();
        if (cooldownMinutes > 0 && (entity = source.m_81373_()) instanceof ServerPlayer) {
            long elapsed;
            ServerPlayer executingPlayer = (ServerPlayer)entity;
            long currentTick = executingPlayer.m_183503_().m_46467_();
            long cooldownTicks = (long)cooldownMinutes.intValue() * 1200L;
            Long lastUse = COOLDOWNS.get(executingPlayer.m_142081_());
            if (lastUse != null && (elapsed = currentTick - lastUse) < cooldownTicks) {
                long remainingTicks = cooldownTicks - elapsed;
                source.m_81352_((Component)new TranslatableComponent("commands.hydrate.cooldown", new Object[]{HydrateCommand.formatCooldown(remainingTicks)}).m_130940_(ChatFormatting.RED));
                return 0;
            }
            COOLDOWNS.put(executingPlayer.m_142081_(), currentTick);
        }
        source.m_81354_((Component)((hydrated = targets.stream().filter(LivingEntity::m_6084_).flatMap(player -> Stream.ofNullable(PlayerExtension.get((Player)player))).peek(HydrateCommand::hydrate).toList()).size() == 1 ? new TranslatableComponent("commands.hydrate.success.single", new Object[]{((ServerPlayer)hydrated.get(0).entity()).m_5446_()}).m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("commands.hydrate.success.multiple", new Object[]{hydrated.size()}).m_130940_(ChatFormatting.GREEN)), false);
        return 0;
    }

    private static void hydrate(PlayerExtension<ServerPlayer> player) {
        ((SurvivalPlayerHandler)player.getHandlerOrThrow(SurvivalPlayerHandler.TYPE)).hydrate();
        ((ServerPlayer)player.entity()).m_6330_(SoundEvents.f_11911_, SoundSource.NEUTRAL, 5.0f, 5.0f);
    }

    private static TextComponent formatCooldown(long remainingTicks) {
        long remainingSeconds = (long)Math.ceil((double)remainingTicks / 20.0);
        long minutes = remainingSeconds / 60L;
        long seconds = remainingSeconds % 60L;
        StringBuilder builder = new StringBuilder();
        if (minutes > 0L) {
            builder.append(minutes).append("m");
        }
        if (seconds > 0L || minutes == 0L) {
            if (minutes > 0L) {
                builder.append(' ');
            }
            builder.append(seconds).append('s');
        }
        return new TextComponent(builder.toString());
    }
}

