/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.util;

import com.craftingdead.immerse.client.util.RenderUtil;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class Blur
implements AutoCloseable {
    private static final Logger logger = LogUtils.getLogger();
    private static final ResourceLocation BLUR_SHADER = new ResourceLocation("craftingdeadimmerse", "shaders/post/blur.json");
    private Minecraft minecraft;
    private PostChain postChain;
    private float lastWidth;
    private float lastHeight;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public Blur() {
        this(-1.0f);
    }

    public Blur(float radius) {
        try {
            this.postChain = new PostChain(this.getMinecraft().m_91097_(), this.getMinecraft().m_91098_(), this.getMinecraft().m_91385_(), BLUR_SHADER);
            this.setRadius(radius);
            this.postChain.m_110025_(this.getMinecraft().m_91268_().m_85441_(), this.getMinecraft().m_91268_().m_85442_());
        }
        catch (JsonSyntaxException | IOException ioexception) {
            logger.warn("Failed to load shader: {}", (Object)BLUR_SHADER, (Object)ioexception);
            this.postChain = null;
        }
    }

    public void setRadius(float radius) {
        if (radius > -1.0f && this.postChain != null) {
            com.craftingdead.core.client.util.RenderUtil.updateUniform((String)"Radius", (float)radius, (PostChain)this.postChain);
        }
    }

    public void tick() {
        int width = this.getMinecraft().m_91385_().f_83915_;
        int height = this.getMinecraft().m_91385_().f_83916_;
        if ((float)width != this.lastWidth || (float)height != this.lastHeight) {
            if (this.postChain != null) {
                this.postChain.m_110025_(this.getMinecraft().m_91268_().m_85441_(), this.getMinecraft().m_91268_().m_85442_());
            }
            this.lastWidth = width;
            this.lastHeight = height;
        }
    }

    public void process(float partialTick) {
        if (this.postChain != null) {
            this.postChain.m_110023_(partialTick);
            this.getMinecraft().m_91385_().m_83947_(false);
        }
    }

    public void render(PoseStack poseStack, float x, float y, float width, float height) {
        if (this.postChain != null) {
            RenderTarget renderTarget = this.postChain.m_110036_("output");
            RenderSystem.m_157453_((int)0, (int)renderTarget.m_83975_());
            float textureWidth = (float)((double)renderTarget.f_83915_ / this.getMinecraft().m_91268_().m_85449_());
            float textureHeight = (float)((double)renderTarget.f_83916_ / this.getMinecraft().m_91268_().m_85449_());
            float textureX = x;
            float textureY = textureHeight - height - y;
            RenderUtil.blit(poseStack, x, y, x + width, y + height, textureX, textureY, textureX + width, textureY + height, textureWidth, textureHeight);
        }
    }

    @Override
    public void close() {
        if (this.postChain != null) {
            this.postChain.close();
        }
    }
}

