/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.trading.view;

import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.trading.view.ItemSlotView;
import com.craftingdead.immerse.network.NetworkChannel;
import com.craftingdead.immerse.trading.TradeCancelReason;
import com.craftingdead.immerse.trading.network.CancelTradeMessage;
import com.craftingdead.immerse.trading.network.ConfirmTradeMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeCurrencyMessage;
import com.craftingdead.immerse.trading.network.UpdateTradeSlotMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import sm0keysa1m0n.bliss.Display;
import sm0keysa1m0n.bliss.layout.Align;
import sm0keysa1m0n.bliss.layout.FlexDirection;
import sm0keysa1m0n.bliss.layout.Justify;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextFieldView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;

public class TradeView
extends ParentView {
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_SPACING = 2;
    private static final int GRID_SIZE = 3;
    private final UUID otherPlayerId;
    private final Component otherPlayerName;
    private final ItemRenderer itemRenderer;
    private final List<ItemSlotView> localTradeSlots = new ArrayList<ItemSlotView>();
    private final List<ItemSlotView> otherTradeSlots = new ArrayList<ItemSlotView>();
    private final List<ItemSlotView> inventorySlots = new ArrayList<ItemSlotView>();
    private int localCurrency;
    private int otherCurrency;
    private boolean localConfirmed;
    private boolean otherConfirmed;
    private TextFieldView localCurrencyInput;
    private TextView otherCurrencyDisplay;
    private TextView localStatusLabel;
    private TextView otherStatusLabel;
    private View confirmButton;
    private View cancelButton;
    private boolean cancelSent = false;

    public TradeView(View.Properties properties, UUID otherPlayerId, Component otherPlayerName, ItemRenderer itemRenderer) {
        super(properties);
        this.otherPlayerId = otherPlayerId;
        this.otherPlayerName = otherPlayerName;
        this.itemRenderer = itemRenderer;
        this.buildUI();
    }

    private void buildUI() {
        this.getStyle().display.set(Display.FLEX);
        this.getStyle().flexDirection.set(FlexDirection.COLUMN);
        this.getStyle().alignItems.set(Align.CENTER);
        this.getStyle().justifyContent.set(Justify.CENTER);
        TextView titleView = new TextView(new View.Properties().id("trade-title").styleClasses("trade-title"));
        titleView.setText((FormattedText)new TranslatableComponent("trade.gui.trading_with", new Object[]{this.otherPlayerName}).m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        this.addChild(titleView);
        ParentView tradePanelContainer = new ParentView(new View.Properties().id("trade-panel-container").styleClasses("trade-panel-container"));
        tradePanelContainer.getStyle().display.set(Display.FLEX);
        tradePanelContainer.getStyle().flexDirection.set(FlexDirection.ROW);
        tradePanelContainer.getStyle().justifyContent.set(Justify.SPACE_AROUND);
        this.addChild(tradePanelContainer);
        ParentView leftPanel = this.createTradePanel((Component)new TranslatableComponent("trade.gui.your_items").m_130940_(ChatFormatting.WHITE), true, tradePanelContainer);
        ParentView rightPanel = this.createTradePanel((Component)new TranslatableComponent("trade.gui.their_items", new Object[]{this.otherPlayerName.getString()}).m_130940_(ChatFormatting.WHITE), false, tradePanelContainer);
        ParentView currencyPanel = new ParentView(new View.Properties().id("currency-panel").styleClasses("currency-panel"));
        currencyPanel.getStyle().display.set(Display.FLEX);
        currencyPanel.getStyle().flexDirection.set(FlexDirection.ROW);
        currencyPanel.getStyle().justifyContent.set(Justify.SPACE_AROUND);
        this.addChild(currencyPanel);
        ParentView localCurrencySection = new ParentView(new View.Properties());
        localCurrencySection.getStyle().display.set(Display.FLEX);
        localCurrencySection.getStyle().flexDirection.set(FlexDirection.ROW);
        localCurrencySection.getStyle().alignItems.set(Align.CENTER);
        currencyPanel.addChild(localCurrencySection);
        TextView localCurrencyLabel = new TextView(new View.Properties());
        localCurrencyLabel.setText((FormattedText)new TranslatableComponent("trade.gui.your_currency").m_130940_(ChatFormatting.GREEN));
        localCurrencySection.addChild(localCurrencyLabel);
        this.localCurrencyInput = new TextFieldView(new View.Properties().id("local-currency-input").styleClasses("currency-input"));
        this.localCurrencyInput.setMaxLength(8);
        this.localCurrencyInput.setResponder(this::handleCurrencyInput);
        localCurrencySection.addChild(this.localCurrencyInput);
        ParentView otherCurrencySection = new ParentView(new View.Properties());
        otherCurrencySection.getStyle().display.set(Display.FLEX);
        otherCurrencySection.getStyle().flexDirection.set(FlexDirection.ROW);
        otherCurrencySection.getStyle().alignItems.set(Align.CENTER);
        currencyPanel.addChild(otherCurrencySection);
        TextView otherCurrencyLabel = new TextView(new View.Properties());
        otherCurrencyLabel.setText((FormattedText)new TranslatableComponent("trade.gui.their_currency", new Object[]{this.otherPlayerName.getString()}).m_130940_(ChatFormatting.YELLOW));
        otherCurrencySection.addChild(otherCurrencyLabel);
        this.otherCurrencyDisplay = new TextView(new View.Properties().id("other-currency-display").styleClasses("currency-display"));
        this.otherCurrencyDisplay.setText((FormattedText)new TextComponent("0").m_130940_(ChatFormatting.GOLD));
        otherCurrencySection.addChild(this.otherCurrencyDisplay);
        ParentView statusPanel = new ParentView(new View.Properties());
        statusPanel.getStyle().display.set(Display.FLEX);
        statusPanel.getStyle().flexDirection.set(FlexDirection.ROW);
        statusPanel.getStyle().justifyContent.set(Justify.SPACE_AROUND);
        this.addChild(statusPanel);
        this.localStatusLabel = new TextView(new View.Properties().id("local-status-label").styleClasses("status-label"));
        statusPanel.addChild(this.localStatusLabel);
        this.otherStatusLabel = new TextView(new View.Properties().id("other-status-label").styleClasses("status-label"));
        statusPanel.addChild(this.otherStatusLabel);
        ParentView inventoryPanel = this.createInventoryPanel();
        this.addChild(inventoryPanel);
        ParentView buttonBar = new ParentView(new View.Properties().id("button-bar").styleClasses("button-bar"));
        buttonBar.getStyle().display.set(Display.FLEX);
        buttonBar.getStyle().flexDirection.set(FlexDirection.ROW);
        buttonBar.getStyle().justifyContent.set(Justify.CENTER);
        this.addChild(buttonBar);
        this.confirmButton = Theme.createGreenButton((Component)new TranslatableComponent("trade.gui.confirm"), this::handleConfirm);
        buttonBar.addChild(this.confirmButton);
        this.cancelButton = Theme.createRedButton((Component)new TranslatableComponent("trade.gui.cancel"), this::handleCancel);
        buttonBar.addChild(this.cancelButton);
    }

    private ParentView createTradePanel(Component titleText, boolean isPlayerPanel, ParentView container) {
        ParentView panel = new ParentView(new View.Properties().id(isPlayerPanel ? "local-trade-panel" : "other-trade-panel").styleClasses("trade-panel"));
        panel.getStyle().display.set(Display.FLEX);
        panel.getStyle().flexDirection.set(FlexDirection.COLUMN);
        panel.getStyle().alignItems.set(Align.CENTER);
        TextView title = new TextView(new View.Properties());
        title.setText((FormattedText)titleText);
        panel.addChild(title);
        ParentView slotsContainer = new ParentView(new View.Properties().styleClasses("slots-container"));
        slotsContainer.getStyle().display.set(Display.FLEX);
        slotsContainer.getStyle().flexDirection.set(FlexDirection.COLUMN);
        panel.addChild(slotsContainer);
        List<ItemSlotView> slotList = isPlayerPanel ? this.localTradeSlots : this.otherTradeSlots;
        for (int row = 0; row < 3; ++row) {
            ParentView rowContainer = new ParentView(new View.Properties());
            rowContainer.getStyle().display.set(Display.FLEX);
            rowContainer.getStyle().flexDirection.set(FlexDirection.ROW);
            slotsContainer.addChild(rowContainer);
            for (int col = 0; col < 3; ++col) {
                int slotIndex = row * 3 + col;
                ItemSlotView slotView = new ItemSlotView(new View.Properties().id((isPlayerPanel ? "local-slot-" : "other-slot-") + slotIndex).styleClasses("trade-slot"), this.itemRenderer, slotIndex, isPlayerPanel);
                if (isPlayerPanel) {
                    slotView.setClickListener(this::handleSlotClick);
                }
                slotList.add(slotView);
                rowContainer.addChild(slotView);
            }
        }
        container.addChild(panel);
        return panel;
    }

    private ParentView createInventoryPanel() {
        ParentView inventoryPanel = new ParentView(new View.Properties().id("inventory-panel").styleClasses("inventory-panel"));
        inventoryPanel.getStyle().display.set(Display.FLEX);
        inventoryPanel.getStyle().flexDirection.set(FlexDirection.COLUMN);
        inventoryPanel.getStyle().alignItems.set(Align.CENTER);
        TextView title = new TextView(new View.Properties());
        title.setText((FormattedText)new TranslatableComponent("container.inventory").m_130940_(ChatFormatting.GRAY));
        inventoryPanel.addChild(title);
        for (int row = 0; row < 3; ++row) {
            ParentView rowContainer = new ParentView(new View.Properties());
            rowContainer.getStyle().display.set(Display.FLEX);
            rowContainer.getStyle().flexDirection.set(FlexDirection.ROW);
            inventoryPanel.addChild(rowContainer);
            for (int col = 0; col < 9; ++col) {
                int slotIndex = 9 + row * 9 + col;
                ItemSlotView slotView = new ItemSlotView(new View.Properties().id("inventory-slot-" + slotIndex).styleClasses("inventory-slot"), this.itemRenderer, slotIndex, false);
                slotView.setClickListener(this::handleInventoryClick);
                this.inventorySlots.add(slotView);
                rowContainer.addChild(slotView);
            }
        }
        ParentView hotbarContainer = new ParentView(new View.Properties());
        hotbarContainer.getStyle().display.set(Display.FLEX);
        hotbarContainer.getStyle().flexDirection.set(FlexDirection.ROW);
        inventoryPanel.addChild(hotbarContainer);
        for (int i = 0; i < 9; ++i) {
            ItemSlotView slotView = new ItemSlotView(new View.Properties().id("hotbar-slot-" + i).styleClasses("inventory-slot"), this.itemRenderer, i, false);
            slotView.setClickListener(this::handleInventoryClick);
            this.inventorySlots.add(slotView);
            hotbarContainer.addChild(slotView);
        }
        return inventoryPanel;
    }

    private void handleSlotClick(ItemSlotView slotView) {
        if (this.localConfirmed) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        ItemStack carried = minecraft.f_91074_.f_36096_.m_142621_();
        int slotIndex = slotView.getSlotIndex();
        if (!carried.m_41619_()) {
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.SERVER.noArg(), (Object)new UpdateTradeSlotMessage(slotIndex, carried.m_41777_(), false));
            minecraft.f_91074_.f_36096_.m_142503_(ItemStack.f_41583_);
        } else {
            ItemStack slotItem = slotView.getItemStack();
            if (!slotItem.m_41619_()) {
                minecraft.f_91074_.f_36096_.m_142503_(slotItem.m_41777_());
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.SERVER.noArg(), (Object)new UpdateTradeSlotMessage(slotIndex, ItemStack.f_41583_, false));
            }
        }
    }

    private void handleInventoryClick(ItemSlotView slotView) {
        if (this.localConfirmed) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        int slotIndex = slotView.getSlotIndex();
        ItemStack carried = minecraft.f_91074_.f_36096_.m_142621_();
        ItemStack inventoryStack = minecraft.f_91074_.m_150109_().m_8020_(slotIndex);
        if (!carried.m_41619_() && inventoryStack.m_41619_()) {
            minecraft.f_91074_.m_150109_().m_6836_(slotIndex, carried.m_41777_());
            minecraft.f_91074_.f_36096_.m_142503_(ItemStack.f_41583_);
        } else if (carried.m_41619_() && !inventoryStack.m_41619_()) {
            minecraft.f_91074_.f_36096_.m_142503_(inventoryStack.m_41777_());
            minecraft.f_91074_.m_150109_().m_6836_(slotIndex, ItemStack.f_41583_);
        } else if (!carried.m_41619_() && !inventoryStack.m_41619_()) {
            ItemStack temp = carried.m_41777_();
            minecraft.f_91074_.f_36096_.m_142503_(inventoryStack.m_41777_());
            minecraft.f_91074_.m_150109_().m_6836_(slotIndex, temp);
        }
        slotView.setItemStack(minecraft.f_91074_.m_150109_().m_8020_(slotIndex));
    }

    private void handleCurrencyInput(String input) {
        if (this.localConfirmed) {
            return;
        }
        try {
            int amount;
            int n = amount = input.isEmpty() ? 0 : Integer.parseInt(input);
            if (amount < 0) {
                amount = 0;
            }
            this.localCurrency = amount;
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.SERVER.noArg(), (Object)new UpdateTradeCurrencyMessage(amount, false));
        }
        catch (NumberFormatException e) {
            this.localCurrency = 0;
        }
    }

    private void handleConfirm() {
        if (this.localConfirmed) {
            return;
        }
        this.localConfirmed = true;
        this.localStatusLabel.setText((FormattedText)new TranslatableComponent("trade.gui.ready").m_130940_(ChatFormatting.GREEN));
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.SERVER.noArg(), (Object)new ConfirmTradeMessage());
    }

    private void handleCancel() {
        if (this.cancelSent) {
            return;
        }
        this.cancelSent = true;
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.SERVER.noArg(), (Object)new CancelTradeMessage(TradeCancelReason.PLAYER_CANCELLED));
    }

    public void updateSlot(boolean isLocalPlayer, int slotIndex, ItemStack itemStack) {
        List<ItemSlotView> slots;
        List<ItemSlotView> list = slots = isLocalPlayer ? this.localTradeSlots : this.otherTradeSlots;
        if (slotIndex >= 0 && slotIndex < slots.size()) {
            slots.get(slotIndex).setItemStack(itemStack);
        }
    }

    public void updateCurrency(boolean isLocalPlayer, int amount) {
        if (isLocalPlayer) {
            this.localCurrency = amount;
        } else {
            this.otherCurrency = amount;
            this.otherCurrencyDisplay.setText((FormattedText)new TextComponent(String.valueOf(amount)).m_130940_(ChatFormatting.GOLD));
        }
    }

    public void setConfirmed(boolean isLocalPlayer, boolean confirmed) {
        if (isLocalPlayer) {
            this.localConfirmed = confirmed;
            if (confirmed) {
                this.localStatusLabel.setText((FormattedText)new TranslatableComponent("trade.gui.ready").m_130940_(ChatFormatting.GREEN));
            } else {
                this.localStatusLabel.setText((FormattedText)TextComponent.f_131282_);
            }
        } else {
            this.otherConfirmed = confirmed;
            if (confirmed) {
                this.otherStatusLabel.setText((FormattedText)new TranslatableComponent("trade.gui.waiting").m_130940_(ChatFormatting.GREEN));
            } else {
                this.otherStatusLabel.setText((FormattedText)TextComponent.f_131282_);
            }
        }
    }

    public void closeTrade() {
    }

    @Override
    public void tick() {
        super.tick();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            ItemStack stack;
            int i;
            for (i = 0; i < 27; ++i) {
                stack = minecraft.f_91074_.m_150109_().m_8020_(9 + i);
                this.inventorySlots.get(i).setItemStack(stack);
            }
            for (i = 0; i < 9; ++i) {
                stack = minecraft.f_91074_.m_150109_().m_8020_(i);
                this.inventorySlots.get(27 + i).setItemStack(stack);
            }
        }
    }
}

