/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.world;

import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.world.WorldItemView;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.KeyFrames;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import sm0keysa1m0n.bliss.Animation;
import sm0keysa1m0n.bliss.style.Percentage;
import sm0keysa1m0n.bliss.style.States;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.View;

public class WorldListView
extends ParentView {
    private static final Logger logger = LogUtils.getLogger();
    private final ParentView listView = new ParentView(new View.Properties().styleClasses("list-content"));
    @Nullable
    private WorldItemView selectedItem;
    private final View playButton;
    private final View editButton;
    private final View deleteButton;
    private final View recreateButton;

    public WorldListView() {
        super(new View.Properties());
        this.loadWorlds();
        this.playButton = Theme.createGreenButton((Component)new TranslatableComponent("view.world_list.button.play"), () -> this.getSelectedItem().ifPresent(WorldItemView::joinWorld));
        this.playButton.setEnabled(false);
        View createButton = Theme.createBlueButton((Component)new TranslatableComponent("view.world_list.button.create"), () -> this.getScreen().keepOpenAndSetScreen((Screen)CreateWorldScreen.m_205424_((Screen)this.getScreen())));
        this.editButton = Theme.createBlueButton((Component)new TranslatableComponent("view.world_list.button.edit"), () -> this.getSelectedItem().ifPresent(WorldItemView::editWorld));
        this.editButton.setEnabled(false);
        this.deleteButton = Theme.createRedButton((Component)new TranslatableComponent("view.world_list.button.delete"), () -> this.getSelectedItem().ifPresent(WorldItemView::deleteWorld));
        this.deleteButton.setEnabled(false);
        this.recreateButton = Theme.createBlueButton((Component)new TranslatableComponent("view.world_list.button.recreate"), () -> this.getSelectedItem().ifPresent(WorldItemView::recreateWorld));
        this.recreateButton.setEnabled(false);
        ParentView controls = new ParentView(new View.Properties().styleClasses("list-controls"));
        ParentView firstRow = new ParentView(new View.Properties());
        firstRow.addChild(this.playButton);
        firstRow.addChild(createButton);
        ParentView secondRow = new ParentView(new View.Properties());
        secondRow.addChild(this.deleteButton);
        secondRow.addChild(this.editButton);
        secondRow.addChild(this.recreateButton);
        controls.addChild(firstRow);
        controls.addChild(secondRow);
        this.addChild(this.listView);
        this.addChild(controls);
    }

    @Override
    protected void added() {
        super.added();
        int delay = 0;
        for (View view : this.listView.getChildren()) {
            new Animator.Builder().addTarget(Animation.forProperty(view.getStyle().opacity).keyFrames((KeyFrames<Percentage>)new KeyFrames.Builder((Object)Percentage.ZERO).addFrame((Object)Percentage.ONE_HUNDRED).build()).build()).setStartDelay((long)delay, TimeUnit.MILLISECONDS).setDuration(250L, TimeUnit.MILLISECONDS).build().start();
            delay += 150;
        }
    }

    public void setSelectedItem(@Nullable WorldItemView selectedItem) {
        if (this.selectedItem == selectedItem) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.getStyleManager().removeState(States.CHECKED);
            this.selectedItem.getStyleManager().notifyListeners();
        }
        this.selectedItem = selectedItem;
        if (selectedItem != null) {
            this.selectedItem.getStyleManager().addState(States.CHECKED);
            this.selectedItem.getStyleManager().notifyListeners();
        }
        boolean enabled = this.selectedItem != null;
        this.playButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.recreateButton.setEnabled(enabled);
    }

    private void loadWorlds() {
        try {
            List saveList = this.minecraft.m_91392_().m_78244_();
            Collections.sort(saveList);
            for (LevelSummary worldSummary : saveList) {
                this.listView.addChild(new WorldItemView(worldSummary, this));
            }
        }
        catch (LevelStorageException e) {
            logger.error("Unable to load save list", (Throwable)e);
        }
    }

    public void reloadWorlds() {
        this.listView.clearChildren();
        this.setSelectedItem(null);
        this.loadWorlds();
    }

    private Optional<WorldItemView> getSelectedItem() {
        return Optional.ofNullable(this.selectedItem);
    }
}

