/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.PingError;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerStatusProvider;
import com.google.common.base.Predicates;
import com.mojang.logging.LogUtils;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class VanillaServerStatusProvider
implements ServerStatusProvider {
    private static final Logger logger = LogUtils.getLogger();
    private static final Component CANNOT_CONNECT_MESSAGE = new TranslatableComponent("multiplayer.status.cannot_connect");
    private static final Scheduler SCHEDULER = Schedulers.newBoundedElastic((int)5, (int)Integer.MAX_VALUE, (String)"server-pinger");
    private final Queue<Connection> connections = new ConcurrentLinkedQueue<Connection>();

    @Override
    public Mono<ServerStatusProvider.Result> checkStatus(ServerEntry serverEntry) {
        return Mono.just((Object)serverEntry.toServerAddress()).map(arg_0 -> ((ServerNameResolver)ServerNameResolver.f_171881_).m_171890_(arg_0)).flatMap(Mono::justOrEmpty).map(ResolvedServerAddress::m_142641_).switchIfEmpty(Mono.error(() -> new PingError(ConnectScreen.f_169260_))).map(address -> Connection.m_178300_((InetSocketAddress)address, (boolean)false)).onErrorMap(ConnectException.class, __ -> new PingError(CANNOT_CONNECT_MESSAGE)).flatMap(connection -> Mono.create(sink -> {
            this.connections.add((Connection)connection);
            connection.m_129505_((net.minecraft.network.PacketListener)new PacketListener((MonoSink<ServerStatusProvider.Result>)sink, (Connection)connection));
            connection.m_129512_((Packet)new ClientIntentionPacket(serverEntry.host(), serverEntry.port(), ConnectionProtocol.STATUS));
            connection.m_129512_((Packet)new ServerboundStatusRequestPacket());
            sink.onDispose(() -> this.connections.remove(connection));
        })).onErrorMap((Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(PingError.class)), error -> {
            logger.warn("An unknown error occurred while pinging: {}:{}", new Object[]{serverEntry.host(), serverEntry.port(), error});
            return new PingError(CANNOT_CONNECT_MESSAGE);
        }).subscribeOn(SCHEDULER);
    }

    public void tick() {
        for (Connection connection : this.connections) {
            if (!connection.m_129536_()) continue;
            connection.m_129483_();
        }
    }

    private static class PacketListener
    implements ClientStatusPacketListener {
        private final MonoSink<ServerStatusProvider.Result> sink;
        private final Connection connection;
        private boolean success;
        private long pingStartMs;
        private long pingStopMs;
        @Nullable
        private ServerStatus status;

        public PacketListener(MonoSink<ServerStatusProvider.Result> sink, Connection connection) {
            this.sink = sink;
            this.connection = connection;
        }

        public void m_6440_(ClientboundStatusResponsePacket packet) {
            if (this.status != null) {
                this.connection.m_129507_((Component)new TranslatableComponent("multiplayer.status.unrequested"));
                this.connection.m_129541_();
                return;
            }
            this.status = packet.m_134897_();
            this.pingStartMs = Util.m_137550_();
            this.connection.m_129512_((Packet)new ServerboundPingRequestPacket(this.pingStartMs));
            this.success = true;
        }

        public void m_7017_(ClientboundPongResponsePacket packetIn) {
            this.pingStopMs = Util.m_137550_();
            this.connection.m_129507_((Component)new TranslatableComponent("multiplayer.status.finished"));
            this.connection.m_129541_();
        }

        public void m_7026_(Component reason) {
            if (this.success) {
                this.sink.success((Object)new ServerStatusProvider.Result(this.pingStopMs - this.pingStartMs, this.status));
            } else {
                this.sink.error((Throwable)new PingError(reason));
            }
        }

        public Connection m_6198_() {
            return this.connection;
        }
    }
}

