/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu.play.list.server;

import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.MutableServerList;
import com.craftingdead.immerse.client.gui.screen.menu.play.list.server.ServerEntry;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class NbtServerList
implements MutableServerList {
    private final Path serverListFile;

    public NbtServerList(Path serverListFile) {
        this.serverListFile = serverListFile;
    }

    @Override
    public Flux<ServerEntry> load() {
        return this.read().flatMapIterable(tag -> tag.m_128437_("servers", 10)).cast(CompoundTag.class).map(serverTag -> new ServerEntry(serverTag.m_128441_("map") ? serverTag.m_128461_("map") : null, serverTag.m_128461_("host"), serverTag.m_128451_("port")));
    }

    @Override
    public Mono<Void> save(Flux<ServerEntry> servers) {
        return servers.map(server -> {
            CompoundTag serverTag = new CompoundTag();
            if (server.map() != null) {
                serverTag.m_128359_("map", server.map());
            }
            serverTag.m_128359_("host", server.host());
            serverTag.m_128405_("port", server.port());
            return serverTag;
        }).collect(Collectors.toCollection(ListTag::new)).map(serversTag -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("servers", (Tag)serversTag);
            return tag;
        }).flatMap(this::save);
    }

    private Mono<CompoundTag> read() {
        return Mono.create(sink -> {
            try (DataInputStream input = new DataInputStream(Files.newInputStream(this.serverListFile, new OpenOption[0]));){
                sink.success((Object)NbtIo.m_128928_((DataInput)input));
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private Mono<Void> save(CompoundTag tag) {
        return Mono.create(sink -> {
            try {
                Path tempFile = Files.createTempFile(this.serverListFile.getParent(), "servers", ".dat", new FileAttribute[0]);
                try (DataOutputStream output = new DataOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]));){
                    NbtIo.m_128941_((CompoundTag)tag, (DataOutput)output);
                    Path oldFile = this.serverListFile.resolveSibling("servers.dat_old");
                    Util.m_137505_((Path)this.serverListFile, (Path)tempFile, (Path)oldFile);
                    sink.success();
                }
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

