/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.menu;

import com.craftingdead.core.tags.ModItemTags;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.immerse.client.fake.FakePlayer;
import com.craftingdead.immerse.client.gui.screen.FogView;
import com.craftingdead.immerse.client.gui.screen.Theme;
import com.craftingdead.immerse.client.gui.screen.menu.HomeView;
import com.craftingdead.immerse.client.gui.screen.menu.TransitionView;
import com.craftingdead.immerse.client.gui.screen.menu.play.PlayView;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.rocketpowered.common.GameProfile;
import net.rocketpowered.common.Role;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.interf.GameClientInterface;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import sm0keysa1m0n.bliss.minecraft.MinecraftUtil;
import sm0keysa1m0n.bliss.minecraft.view.AvatarView;
import sm0keysa1m0n.bliss.minecraft.view.EntityView;
import sm0keysa1m0n.bliss.view.ImageView;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.ViewScreen;

public class MainMenuView
extends ParentView {
    private static final Component TITLE = new TranslatableComponent("menu.home.title");
    private final ParentView contentContainer = new ParentView(new View.Properties().id("content"));
    private final TextView roleTextView = new TextView(new View.Properties()).setWrap(false);
    private Disposable listener;

    public MainMenuView() {
        super(new View.Properties());
        HomeView homeView = new HomeView();
        this.contentContainer.addChild(homeView);
        PlayView playView = new PlayView();
        this.addChild(Theme.createBackground());
        this.addChild(new FogView(new View.Properties()));
        ParentView profileBar = new ParentView(new View.Properties().id("profile-bar").styleClasses("side-bar", "blur", "shadow"));
        ParentView profileView = new ParentView(new View.Properties().id("profile"));
        profileView.addChild(new AvatarView(new View.Properties().id("avatar").styleClasses("shadow"), this.minecraft.m_91094_().m_92548_()));
        ParentView profileTextView = new ParentView(new View.Properties().id("profile-text"));
        profileTextView.addChild(new TextView(new View.Properties().id("name").styleClasses("profile-name")).setWrap(false).setText(this.minecraft.m_91094_().m_92546_()));
        profileTextView.addChild(this.roleTextView);
        profileView.addChild(profileTextView);
        profileBar.addChild(profileView);
        ParentView rankView = new ParentView(new View.Properties().id("rank"));
        rankView.addChild(new ImageView(new View.Properties().id("rank-icon").styleClasses("shadow")).setImage(MinecraftUtil.createImageAccess(new ResourceLocation("craftingdeadimmerse", "textures/gui/rank/chicken.png"))));
        rankView.addChild(new TextView(new View.Properties()).setText((FormattedText)new TranslatableComponent("view.main_menu.rank")));
        profileBar.addChild(rankView);
        profileBar.addChild(Theme.newSeparator());
        ParentView menuBar = new ParentView(new View.Properties().id("menu-bar").styleClasses("side-bar", "blur"));
        menuBar.addChild(this.createButton(new ResourceLocation("craftingdeadimmerse", "textures/gui/logo.svg"), new View.Properties().id("home"), (FormattedText)new TranslatableComponent("menu.home_button"), () -> this.transitionTo(homeView)));
        menuBar.addChild(Theme.newSeparator());
        menuBar.addChild(this.createButton(new ResourceLocation("craftingdeadimmerse", "textures/gui/play.svg"), new View.Properties().id("play").styleClasses("grow-button"), (FormattedText)new TranslatableComponent("menu.play_button"), () -> this.transitionTo(playView)));
        menuBar.addChild(this.createButton(new ResourceLocation("craftingdeadimmerse", "textures/gui/settings.svg"), new View.Properties().id("settings").styleClasses("grow-button"), (FormattedText)new TranslatableComponent("menu.options"), () -> this.getScreen().keepOpenAndSetScreen((Screen)new OptionsScreen((Screen)this.getScreen(), this.minecraft.f_91066_))));
        menuBar.addChild(this.createButton("quit-container", new ResourceLocation("craftingdeadimmerse", "textures/gui/power.svg"), new View.Properties().id("quit").styleClasses("grow-button"), (FormattedText)new TranslatableComponent("menu.quit"), () -> ((Minecraft)this.minecraft).m_91395_()));
        FakePlayer fakePlayerEntity = new FakePlayer(this.minecraft.m_91094_().m_92548_());
        ItemStack hatItem = ForgeRegistries.ITEMS.tags().getTag(ModItemTags.HATS).getRandomElement((Random)ThreadLocalRandom.current()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
        LivingExtension livingExtension = LivingExtension.getOrThrow((LivingEntity)fakePlayerEntity);
        livingExtension.setItemInSlot(Equipment.Slot.HAT, hatItem);
        ParentView entityContainer = new ParentView(new View.Properties().id("entity-container"));
        entityContainer.addChild(new EntityView(new View.Properties(), (LivingEntity)fakePlayerEntity));
        this.addChild(entityContainer);
        this.addChild(this.contentContainer);
        this.addChild(menuBar);
        this.addChild(profileBar);
    }

    @Override
    protected void added() {
        super.added();
        AtomicReference primaryRole = new AtomicReference();
        this.listener = Rocket.gameClientInterfaceFeed().flatMap(gateway -> gateway.getGameProfileFeed().doOnNext(__ -> primaryRole.set(null)).flatMapIterable(GameProfile::roles).flatMap(arg_0 -> ((GameClientInterface)gateway).getRoleFeed(arg_0)).doOnNext(role -> {
            Role newRole = (Role)primaryRole.updateAndGet(oldRole -> oldRole == null || role.compareTo(oldRole) > 0 ? role : oldRole);
            this.roleTextView.setText((FormattedText)(newRole == null ? TextComponent.f_131282_ : new TextComponent(newRole.name())));
        })).subscribe();
    }

    @Override
    protected void removed() {
        super.removed();
        this.listener.dispose();
    }

    private View createButton(ResourceLocation imageLocation, View.Properties properties, FormattedText tooltip, Runnable actionListener) {
        return this.createButton(null, imageLocation, properties, tooltip, actionListener);
    }

    private View createButton(@Nullable String containerId, ResourceLocation imageLocation, View.Properties properties, FormattedText tooltip, Runnable actionListener) {
        ParentView buttonContainer = new ParentView(new View.Properties().id(containerId).styleClasses("tooltip-container"));
        buttonContainer.addChild(Theme.createImageButton(imageLocation, actionListener, properties));
        ParentView tooltipView = new ParentView(new View.Properties().styleClasses("tooltip"));
        tooltipView.addChild(new TextView(new View.Properties()).setText(tooltip));
        buttonContainer.addChild(tooltipView);
        return buttonContainer;
    }

    private void transitionTo(View view) {
        List<? extends View> views = this.contentContainer.getChildren();
        if (views.contains(view)) {
            return;
        }
        if (views.size() == 1) {
            View currentView = views.get(0);
            if (currentView instanceof TransitionView) {
                TransitionView animatable = (TransitionView)((Object)currentView);
                animatable.transitionOut(() -> {
                    this.contentContainer.removeChild(currentView);
                    this.contentContainer.layout();
                });
            } else {
                this.contentContainer.removeChild(currentView);
            }
        }
        this.contentContainer.addChild(view);
        this.contentContainer.layout();
    }

    public static Screen createScreen() {
        ViewScreen screen = new ViewScreen(TITLE, new MainMenuView());
        screen.setStylesheets(List.of(new ResourceLocation("craftingdeadimmerse", "main-menu")));
        return screen;
    }
}

