/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen.game.shop;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.client.gui.screen.game.shop.GameButton;
import com.craftingdead.immerse.client.gui.screen.game.shop.InfoPanel;
import com.craftingdead.immerse.client.util.RenderUtil;
import com.craftingdead.immerse.game.module.shop.ClientShopModule;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractShopScreen
extends Screen {
    private static final Component TITLE = new TranslatableComponent("gui.screen.shop.title");
    private final List<GameButton> shopButtons = new ArrayList<GameButton>();
    private final Screen lastScreen;
    private final ClientShopModule shop;
    private final PlayerExtension<?> player;
    private int cachedBuyTime = -1;

    public AbstractShopScreen(Screen lastScreen, ClientShopModule shop, PlayerExtension<?> player) {
        super(TITLE);
        this.lastScreen = lastScreen;
        this.shop = shop;
        this.player = player;
    }

    protected void addShopButton(GameButton shopButton) {
        this.shopButtons.add(shopButton);
    }

    public ClientShopModule getShop() {
        return this.shop;
    }

    public void m_7856_() {
        int mx = this.f_96543_ / 2;
        int my = this.f_96544_ / 2;
        int x = mx - 140;
        int y = my - 72;
        int w1 = 100;
        int h1 = 20;
        int ym = 22;
        for (int i = 0; i < this.shopButtons.size(); ++i) {
            GameButton shopButton = this.shopButtons.get(i);
            shopButton.f_93620_ = x;
            shopButton.f_93621_ = y + i * ym;
            shopButton.m_93674_(w1);
            shopButton.setHeight(h1);
            this.m_142416_((GuiEventListener)shopButton);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 66) {
            this.f_96541_.m_91152_(this.lastScreen);
            return true;
        }
        return false;
    }

    public void m_96624_() {
        this.cachedBuyTime = this.shop.getBuyTimeSeconds();
        if (this.cachedBuyTime <= 0) {
            this.m_7379_();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean renderMoney;
        this.m_7333_(poseStack);
        int mx = this.f_96543_ / 2;
        int my = this.f_96544_ / 2;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWithShadow(poseStack, 0.0f, 0.0f, this.f_96543_, 30.0f, Integer.MIN_VALUE);
        RenderUtil.fillWithShadow(poseStack, 0.0f, this.f_96544_ - 30, this.f_96543_, 30.0f, Integer.MIN_VALUE);
        AbstractShopScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("gui.screen.shop.back", new Object[]{"B"}).m_130940_(ChatFormatting.ITALIC), (int)(mx - 150), (int)18, (int)-1);
        AbstractShopScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_().m_6881_().m_130940_(ChatFormatting.BOLD), (int)mx, (int)10, (int)-1);
        RenderUtil.renderTextRight(this.f_96547_, poseStack, (float)(mx + 150), 18.0f, (Component)new TranslatableComponent("gui.screen.shop.buy_time", new Object[]{new TextComponent(String.valueOf(this.cachedBuyTime)).m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.ITALIC), -1, true);
        int bh = this.shopButtons.size() * 22;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWithShadow(poseStack, mx - 150, my - 80, 120.0f, bh + 15, Integer.MIN_VALUE);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWithShadow(poseStack, mx - 25, my - 80, 115.0f, 160.0f, Integer.MIN_VALUE);
        this.f_96547_.m_92763_(poseStack, (Component)new TranslatableComponent("gui.screen.shop.selected").m_130940_(ChatFormatting.BOLD), (float)(mx - 20), (float)(my - 75), -1);
        for (GameButton shopButton : this.shopButtons) {
            if (!(shopButton instanceof InfoPanel)) continue;
            InfoPanel infoPanel = (InfoPanel)((Object)shopButton);
            if (!shopButton.m_198029_()) continue;
            infoPanel.renderInfo((Level)this.f_96541_.f_91073_, mx, my, poseStack, mouseX, mouseY, partialTick);
        }
        int spacing = 5;
        int moneyHeight = 15;
        boolean bl = renderMoney = this.shop.getMoney() > -1;
        if (renderMoney) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderUtil.fillWithShadow(poseStack, mx + 95, my - 80, 69.0f, 15.0f, Integer.MIN_VALUE);
            this.f_96547_.m_92763_(poseStack, (Component)new TextComponent("$" + this.shop.getMoney()).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), (float)(mx + 100), (float)(my - 76), 0);
        }
        int inventoryYOffset = renderMoney ? 20 : 0;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderUtil.fillWithShadow(poseStack, mx + 95, my - 80 + inventoryYOffset, 69.0f, 140.0f, Integer.MIN_VALUE);
        this.f_96547_.m_92763_(poseStack, (Component)new TranslatableComponent("gui.screen.shop.inventory").m_130940_(ChatFormatting.BOLD), (float)(mx + 100), (float)(my - 75 + inventoryYOffset), -1);
        Inventory inventory = ((Player)this.player.entity()).m_150109_();
        for (int i = 0; i < 7; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            com.craftingdead.core.client.util.RenderUtil.renderItemInCombatSlot((ItemStack)itemStack, (int)(mx + 160), (int)(my - 60 + inventoryYOffset + i * 21), (PoseStack)poseStack, (float)partialTick);
        }
    }
}

