/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui.screen;

import com.craftingdead.immerse.client.gui.screen.FogView;
import com.craftingdead.immerse.client.gui.screen.Theme;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import sm0keysa1m0n.bliss.view.ParentView;
import sm0keysa1m0n.bliss.view.TextView;
import sm0keysa1m0n.bliss.view.View;
import sm0keysa1m0n.bliss.view.ViewScreen;

public class ConnectView
extends ParentView {
    private static final Logger logger = LogUtils.getLogger();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-connector-%s").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(logger)).build());
    private final Iterator<String> animation = Iterators.cycle((Object[])new String[]{"O o o", "o O o", "o o O"});
    private long lastAnimationUpdateMs;
    private Connection connection;
    private boolean aborted;
    private final Screen lastScreen;
    private final TextView statusView;
    private final TextView animationView;

    public ConnectView(Screen lastScreen, ServerAddress address) {
        super(new View.Properties());
        this.lastScreen = lastScreen;
        this.addChild(Theme.createBackground());
        this.addChild(new FogView(new View.Properties()));
        ParentView dialog = new ParentView(new View.Properties().id("dialog").styleClasses("blur"));
        this.addChild(dialog);
        this.statusView = new TextView(new View.Properties().id("status")).setText((FormattedText)new TranslatableComponent("connect.connecting"));
        dialog.addChild(this.statusView);
        this.animationView = new TextView(new View.Properties().id("animation")).setText((FormattedText)this.nextAnimation());
        dialog.addChild(this.animationView);
        dialog.addChild(Theme.createRedButton(CommonComponents.f_130656_, () -> {
            this.aborted = true;
            if (this.connection != null) {
                this.connection.m_129507_((Component)new TranslatableComponent("connect.aborted"));
            }
            this.minecraft.m_91152_(this.lastScreen);
        }, "cancel-button"));
        this.minecraft.m_91399_();
        this.connect(address);
    }

    private void connect(ServerAddress serverAddress) {
        logger.info("Connecting to {}:{}", (Object)serverAddress.m_171863_(), (Object)serverAddress.m_171866_());
        executorService.submit(() -> {
            InetSocketAddress inetAddress = null;
            try {
                Optional<InetSocketAddress> optional = ServerNameResolver.f_171881_.m_171890_(serverAddress).map(ResolvedServerAddress::m_142641_);
                if (this.aborted) {
                    return;
                }
                if (!optional.isPresent()) {
                    this.minecraft.execute(() -> this.minecraft.m_91152_((Screen)new DisconnectedScreen((Screen)this.getScreen(), CommonComponents.f_130661_, ConnectScreen.f_169260_)));
                    return;
                }
                inetAddress = optional.get();
                this.connection = Connection.m_178300_((InetSocketAddress)inetAddress, (boolean)this.minecraft.f_91066_.m_92175_());
                this.connection.m_129505_((PacketListener)new ClientHandshakePacketListenerImpl(this.connection, this.minecraft, this.lastScreen, text -> this.minecraft.execute(() -> this.statusView.setText((FormattedText)text))));
                this.connection.m_129512_((Packet)new ClientIntentionPacket(inetAddress.getHostName(), inetAddress.getPort(), ConnectionProtocol.LOGIN));
                this.connection.m_129512_((Packet)new ServerboundHelloPacket(this.minecraft.m_91094_().m_92548_()));
            }
            catch (Exception e) {
                if (this.aborted) {
                    return;
                }
                logger.error("Couldn't connect to server", (Throwable)e);
                String censoredReason = inetAddress == null ? e.getMessage() : e.getMessage().replaceAll(inetAddress.getHostName() + ":" + inetAddress.getPort(), "").replaceAll(inetAddress.toString(), "");
                this.minecraft.execute(() -> this.minecraft.m_91152_((Screen)new DisconnectedScreen(this.lastScreen, CommonComponents.f_130661_, (Component)new TranslatableComponent("disconnect.genericReason", new Object[]{censoredReason}))));
            }
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.connection != null) {
            if (this.connection.m_129536_()) {
                this.connection.m_129483_();
            } else {
                this.connection.m_129541_();
                return;
            }
        }
        long currentTime = Util.m_137550_();
        if (this.lastAnimationUpdateMs != -1L && currentTime - this.lastAnimationUpdateMs >= 100L) {
            this.lastAnimationUpdateMs = currentTime;
            this.animationView.setText((FormattedText)this.nextAnimation());
        }
    }

    private Component nextAnimation() {
        return new TextComponent(this.animation.next()).m_130940_(ChatFormatting.GRAY);
    }

    public static Screen createScreen(Screen lastScreen, ServerAddress address) {
        ViewScreen screen = new ViewScreen(NarratorChatListener.f_93310_, new ConnectView(lastScreen, address));
        screen.setStylesheets(List.of(new ResourceLocation("craftingdeadimmerse", "connect")));
        return screen;
    }
}

