/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client.gui;

import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.immerse.client.gui.KilledMessage;
import com.craftingdead.immerse.world.KillFeedEntry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class IngameGui {
    private static final int KILLED_MESSAGE_LIFE_MS = 5000;
    private static final int KILL_FEED_MESSAGE_LIFE_MS = 5000;
    private Minecraft minecraft;
    private final Queue<KillFeedEntry> killFeedMessages = new ArrayDeque<KillFeedEntry>();
    private long killedMessageVisibleTimeMs;
    private KilledMessage killedMessage;
    private long killFeedVisibleTimeMs;
    private long killFeedAnimationTimeMs;

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public void addKillFeedEntry(KillFeedEntry killFeedMessage) {
        if (this.killFeedMessages.isEmpty()) {
            this.killFeedVisibleTimeMs = 0L;
        }
        this.killFeedMessages.add(killFeedMessage);
    }

    public void renderOverlay(PlayerExtension<AbstractClientPlayer> player, PoseStack poseStack, int width, int height, float partialTick) {
        this.renderKilledMessage(poseStack, width, height);
        this.renderKillFeed(poseStack, partialTick);
    }

    private void renderKilledMessage(PoseStack poseStack, int width, int height) {
        if (this.killedMessage != null) {
            long currentTime = Util.m_137550_();
            if (currentTime - this.killedMessageVisibleTimeMs > 5000L) {
                this.killedMessage = null;
                return;
            }
            this.killedMessage.render(poseStack, this.getMinecraft().f_91062_, width, height);
        }
    }

    public void displayKilledMessage(KilledMessage killedMessage) {
        this.killedMessageVisibleTimeMs = Util.m_137550_();
        this.killedMessage = killedMessage;
    }

    private void renderKillFeed(PoseStack poseStack, float partialTick) {
        long currentTime;
        float durationPct;
        if (this.killFeedVisibleTimeMs == 0L) {
            this.killFeedVisibleTimeMs = Util.m_137550_();
            this.killFeedAnimationTimeMs = 0L;
        }
        if ((durationPct = Mth.m_14036_((float)((float)((currentTime = Util.m_137550_()) - this.killFeedVisibleTimeMs) / 5000.0f), (float)0.0f, (float)1.0f)) == 1.0f && !this.killFeedMessages.isEmpty()) {
            this.killFeedMessages.poll();
            if (!this.killFeedMessages.isEmpty()) {
                this.killFeedVisibleTimeMs = Util.m_137550_();
                this.killFeedAnimationTimeMs = 0L;
            }
        } else if (durationPct >= 0.75f && this.killFeedAnimationTimeMs == 0L) {
            this.killFeedAnimationTimeMs = Util.m_137550_();
        }
        float animationPct = this.killFeedAnimationTimeMs != 0L ? Mth.m_14036_((float)((float)(currentTime - this.killFeedAnimationTimeMs) / (1250.0f - partialTick)), (float)0.0f, (float)1.0f) : 0.0f;
        int killFeedMessageX = 5;
        int i = 0;
        for (KillFeedEntry killFeedMessage : this.killFeedMessages) {
            float killFeedMessageY = 5.0f + ((float)i - 1.0f * animationPct) * 12.0f;
            this.renderKillFeedEntry(killFeedMessage, poseStack, 5.0f, killFeedMessageY, i == 0 ? 1.0f - animationPct : 1.0f);
            ++i;
        }
    }

    private void renderKillFeedEntry(KillFeedEntry entry, PoseStack poseStack, float x, float y, float alpha) {
        Component killerName = entry.killerName();
        Component deadName = entry.targetName();
        int killerNameWidth = this.getMinecraft().f_91062_.m_92852_((FormattedText)killerName);
        int deadNameWidth = this.getMinecraft().f_91062_.m_92852_((FormattedText)deadName);
        int spacing = 20;
        alpha *= entry.killerEntityId() == this.getMinecraft().f_91074_.m_142049_() ? 0.7f : 0.5f;
        switch (entry.type()) {
            case WALLBANG_HEADSHOT: {
                spacing += 16;
            }
            case HEADSHOT: 
            case WALLBANG: {
                spacing += 16;
                break;
            }
        }
        int opacity = Math.min((int)(alpha * 255.0f), 255);
        if (opacity < 8) {
            return;
        }
        int colour = 0 + (opacity << 24);
        RenderUtil.fillGradient((PoseStack)poseStack, (float)x, (float)y, (float)(x + (float)killerNameWidth + (float)deadNameWidth + (float)spacing), (float)(y + 11.0f), (int)colour, (int)colour);
        this.getMinecraft().f_91062_.m_92763_(poseStack, killerName, x + 2.0f, y + 2.0f, 0xFFFFFF + ((int)(alpha * 255.0f) << 24));
        this.getMinecraft().f_91062_.m_92763_(poseStack, deadName, x + (float)killerNameWidth + (float)spacing - 1.0f, y + 2.0f, 0xFFFFFF + (opacity << 24));
        switch (entry.type()) {
            case HEADSHOT: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit((float)(x + (float)killerNameWidth + 17.0f), (float)(y - 1.0f), (float)12.0f, (float)12.0f);
                RenderSystem.m_69461_();
                break;
            }
            case WALLBANG: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit((float)(x + (float)killerNameWidth + 35.0f), (float)(y - 1.0f), (float)12.0f, (float)12.0f);
                RenderSystem.m_69461_();
                break;
            }
            case WALLBANG_HEADSHOT: {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/wallbang.png"));
                RenderUtil.blit((float)(x + (float)killerNameWidth + 35.0f), (float)(y - 1.0f), (float)12.0f, (float)12.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("craftingdead", "textures/gui/headshot.png"));
                RenderUtil.blit((float)(x + (float)killerNameWidth + 35.0f + 14.0f), (float)(y - 1.0f), (float)12.0f, (float)12.0f);
                RenderSystem.m_69461_();
                break;
            }
        }
        if (!entry.weaponStack().m_41619_()) {
            float scale;
            poseStack.m_85836_();
            poseStack.m_85837_((double)(x + (float)killerNameWidth + 4.0f), (double)(y - 1.0f), 0.0);
            if (entry.weaponStack().m_41720_() instanceof GunItem) {
                scale = 0.75f;
                poseStack.m_85841_(scale, scale, scale);
            }
            if (entry.weaponStack().m_41720_() instanceof GrenadeItem) {
                scale = 0.8f;
                poseStack.m_85841_(scale, scale, scale);
                poseStack.m_85837_(4.0, 1.0, 0.0);
            }
            RenderUtil.renderGuiItem((PoseStack)poseStack, (ItemStack)entry.weaponStack(), (float)alpha);
            poseStack.m_85849_();
        }
    }
}

