/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.immerse.client;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.telemetry.TelemetryManager;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.immerse.CraftingDeadImmerse;
import com.craftingdead.immerse.ModDist;
import com.craftingdead.immerse.client.fake.FakePlayer;
import com.craftingdead.immerse.client.gui.IngameGui;
import com.craftingdead.immerse.client.gui.screen.menu.MainMenuView;
import com.craftingdead.immerse.client.renderer.BlueprintOutlineRenderer;
import com.craftingdead.immerse.client.renderer.SpectatorRenderer;
import com.craftingdead.immerse.client.renderer.entity.layer.TeamClothingLayer;
import com.craftingdead.immerse.client.shader.RectShader;
import com.craftingdead.immerse.client.shader.RoundedRectShader;
import com.craftingdead.immerse.client.shader.RoundedTexShader;
import com.craftingdead.immerse.game.ClientGameWrapper;
import com.craftingdead.immerse.game.GameClient;
import com.craftingdead.immerse.game.GameType;
import com.craftingdead.immerse.game.LogicalServer;
import com.craftingdead.immerse.server.ServerConfig;
import com.craftingdead.immerse.world.item.BlueprintItem;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.concurrent.Executor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.rocketpowered.connector.client.gui.RocketToast;
import net.rocketpowered.sdk.Rocket;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.TimingSource;
import org.jdesktop.core.animation.timing.sources.ManualTimingSource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import reactor.core.scheduler.Schedulers;
import sm0keysa1m0n.bliss.Bliss;
import sm0keysa1m0n.bliss.minecraft.platform.MinecraftGraphicsContext;
import sm0keysa1m0n.bliss.minecraft.platform.MinecraftPlatform;
import sm0keysa1m0n.bliss.style.StyleSheetManager;
import sm0keysa1m0n.bliss.view.ViewScreen;

public class ClientDist
implements ModDist {
    private static final ManualTimingSource timingSource = new ManualTimingSource();
    public static final KeyMapping SWITCH_TEAMS = new KeyMapping("key.switch_teams", 77, "key.categories.gameplay");
    public static final KeyMapping TOGGLE_STATS = new KeyMapping("key.toggle_stats", -1, "key.categories.misc");
    public static final ResourceLocation BLUR_SHADER = new ResourceLocation("craftingdeadimmerse", "shaders/post/fade_in_blur.json");
    private static final Logger logger = LogUtils.getLogger();
    @Nullable
    private Minecraft minecraft;
    private MinecraftGraphicsContext graphicsContext;
    @Nullable
    private LogicalServer logicalServer;
    private ClientGameWrapper gameWrapper;
    private final SpectatorRenderer spectatorRenderer;
    private final BlueprintOutlineRenderer blueprintOutlineRenderer;
    private final IngameGui ingameGui;
    private boolean firstLoad = true;
    @Nullable
    private static RectShader rectShader;
    @Nullable
    private static RoundedRectShader roundedRectShader;
    @Nullable
    private static RoundedTexShader roundedTexShader;

    public ClientDist() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::handleClientSetup);
        modBus.addListener(this::handleEntityRenderersAddLayers);
        modBus.addListener(this::handleRegisterShaders);
        modBus.addListener(this::handleRegisterClientReloadListeners);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.spectatorRenderer = new SpectatorRenderer();
        this.blueprintOutlineRenderer = new BlueprintOutlineRenderer();
        this.ingameGui = new IngameGui();
    }

    private Minecraft getMinecraft() {
        if (this.minecraft == null) {
            Minecraft mc;
            this.minecraft = mc = Minecraft.m_91087_();
        }
        return this.minecraft;
    }

    public MinecraftGraphicsContext getGraphicsContext() {
        if (this.graphicsContext == null) {
            Minecraft mc = this.getMinecraft();
            this.graphicsContext = new MinecraftGraphicsContext(mc.m_91268_().m_85439_(), mc.m_91385_());
        }
        return this.graphicsContext;
    }

    @Nullable
    public ClientGameWrapper getGameWrapper() {
        return this.gameWrapper;
    }

    @Nullable
    public GameClient getGameClient() {
        return this.gameWrapper == null ? null : (GameClient)this.gameWrapper.getGame();
    }

    public SpectatorRenderer getSpectatorRenderer() {
        return this.spectatorRenderer;
    }

    public IngameGui getIngameGui() {
        return this.ingameGui;
    }

    public void loadGame(GameType gameType) {
        logger.info("Loading game: {}", (Object)gameType.getRegistryName().toString());
        try {
            if (this.gameWrapper != null) {
                this.gameWrapper.unload();
            }
            this.gameWrapper = new ClientGameWrapper(gameType.createGameClient());
            this.gameWrapper.load();
        }
        catch (Exception e) {
            logger.error("Failed to load game", (Throwable)e);
        }
    }

    @Nullable
    public static RectShader getRectShader() {
        return rectShader;
    }

    @Nullable
    public static RoundedRectShader getRoundedRectShader() {
        return roundedRectShader;
    }

    @Nullable
    public static RoundedTexShader getRoundedTexShader() {
        return roundedTexShader;
    }

    @Override
    public LogicalServer createLogicalServer(MinecraftServer minecraftServer) {
        return new LogicalServer(minecraftServer);
    }

    private void handleRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)StyleSheetManager.getInstance());
    }

    private void handleEntityRenderersAddLayers(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(skin -> {
            LivingEntityRenderer renderer = event.getSkin(skin);
            renderer.m_115326_(new TeamClothingLayer(renderer));
        });
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.m_91087_();
        }
        Bliss.initialize(this.graphicsContext, new MinecraftPlatform(this.minecraft));
        ClientRegistry.registerKeyBinding((KeyMapping)SWITCH_TEAMS);
        ClientRegistry.registerKeyBinding((KeyMapping)TOGGLE_STATS);
        this.blueprintOutlineRenderer.register();
        event.enqueueWork(() -> this.publishTelemetryUserDetails(null));
        this.minecraft.m_18707_(() -> {
            StartupMessageManager.addModMessage((String)"Applying branding");
            try {
                InputStream smallIcon = this.minecraft.m_91098_().m_142591_(new ResourceLocation("craftingdeadimmerse", "textures/gui/icons/icon_16x16.png")).m_6679_();
                InputStream mediumIcon = this.minecraft.m_91098_().m_142591_(new ResourceLocation("craftingdeadimmerse", "textures/gui/icons/icon_32x32.png")).m_6679_();
                this.minecraft.m_91268_().m_85395_(smallIcon, mediumIcon);
            }
            catch (IOException e) {
                logger.error("Couldn't set icon", (Throwable)e);
            }
        });
    }

    private void handleRegisterShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("craftingdeadimmerse", "rect"), DefaultVertexFormat.f_85815_), shader -> {
                rectShader = new RectShader((ShaderInstance)shader);
            });
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("craftingdeadimmerse", "rounded_rect"), DefaultVertexFormat.f_85815_), shader -> {
                roundedRectShader = new RoundedRectShader((ShaderInstance)shader);
            });
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("craftingdeadimmerse", "rounded_tex"), DefaultVertexFormat.f_85817_), shader -> {
                roundedTexShader = new RoundedTexShader((ShaderInstance)shader);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SubscribeEvent
    public void handleRenderNameplate(RenderNameplateEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        String remoteAddress = null;
        Connection networkConnection = event.getConnection();
        if (networkConnection != null) {
            remoteAddress = String.valueOf(networkConnection.m_129523_());
        }
        this.publishTelemetryUserDetails(remoteAddress);
    }

    @SubscribeEvent
    public void handlePlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (this.gameWrapper != null) {
            this.gameWrapper.unload();
            this.gameWrapper = null;
        }
        this.publishTelemetryUserDetails(null);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerExtension player = CraftingDead.getInstance().getClientDist().getPlayerExtension().orElse(null);
        PlayerExtension viewingPlayer = this.minecraft.m_91288_() instanceof AbstractClientPlayer ? (PlayerExtension)((AbstractClientPlayer)this.minecraft.m_91288_()).getCapability(LivingExtension.CAPABILITY).cast().orElse(null) : null;
        switch (event.getType()) {
            case ALL: {
                if (viewingPlayer == null || this.getGameClient() == null) break;
                this.ingameGui.renderOverlay((PlayerExtension<AbstractClientPlayer>)viewingPlayer, event.getMatrixStack(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getPartialTicks());
                event.setCanceled(this.getGameClient().renderOverlay((PlayerExtension<? extends AbstractClientPlayer>)viewingPlayer, event.getMatrixStack(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getPartialTicks()));
                break;
            }
            case PLAYER_LIST: {
                if (player == null || this.getGameClient() == null) break;
                event.setCanceled(this.getGameClient().renderPlayerList((PlayerExtension<? extends AbstractClientPlayer>)player, event.getMatrixStack(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getPartialTicks()));
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleScreenOpen(ScreenOpenEvent event) {
        if (event.getScreen() instanceof TitleScreen && this.firstLoad) {
            Rocket.gameClientInterfaceFeed().doOnNext(__ -> RocketToast.info(this.minecraft, "Connected to Rocket")).flatMap(connection -> connection.onClose().doOnSuccess(__ -> RocketToast.info(this.minecraft, "Disconnected from Rocket"))).publishOn(Schedulers.fromExecutor((Executor)this.minecraft)).subscribe();
            this.firstLoad = false;
        }
        if (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof JoinMultiplayerScreen) {
            ViewScreen screen;
            Screen screen2 = this.minecraft.f_91080_;
            if (screen2 instanceof ViewScreen && (screen = (ViewScreen)screen2).getRoot() instanceof MainMenuView) {
                event.setCanceled(true);
                return;
            }
            if (Bliss.instance() == null) {
                Bliss.initialize(this.getGraphicsContext(), new MinecraftPlatform(this.getMinecraft()));
            }
            event.setScreen(MainMenuView.createScreen());
        }
    }

    @SubscribeEvent
    public void handleClientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                boolean worldFocused;
                if (this.gameWrapper != null) {
                    this.gameWrapper.tick();
                }
                if (this.minecraft.f_91074_ == null) break;
                boolean bl = worldFocused = !this.minecraft.m_91104_() && this.minecraft.m_91265_() == null && this.minecraft.f_91080_ == null;
                if (this.minecraft.f_91074_.m_5833_() && this.minecraft.m_91288_() instanceof RemotePlayer) {
                    this.spectatorRenderer.tick((AbstractClientPlayer)this.minecraft.m_91288_());
                }
                if (!worldFocused || this.getGameClient() == null || !this.getGameClient().disableSwapHands()) break;
                while (this.minecraft.f_91066_.f_92093_.m_90859_()) {
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleRenderTick(TickEvent.RenderTickEvent event) {
        switch (event.phase) {
            case START: {
                timingSource.tick();
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleDrawHighlightBlock(DrawSelectionEvent.HighlightBlock event) {
        Item item;
        PlayerExtension cameraPlayer = CraftingDead.getInstance().getClientDist().getCameraPlayer();
        if (cameraPlayer != null && (item = cameraPlayer.mainHandItem().m_41720_()) instanceof BlueprintItem) {
            BlueprintItem blueprint = (BlueprintItem)item;
            event.setCanceled(true);
            this.blueprintOutlineRenderer.render((PlayerExtension<AbstractClientPlayer>)cameraPlayer, blueprint, event.getTarget(), event.getCamera(), event.getPoseStack(), event.getMultiBufferSource());
        }
    }

    @SubscribeEvent
    public void handleNameplate(RenderNameplateEvent event) {
        switch ((ServerConfig.NametagMode)((Object)CraftingDeadImmerse.serverConfig.nametagMode.get())) {
            case LOOK: {
                if (!(event.getEntity() instanceof Player) || Minecraft.m_91087_().f_91076_ == event.getEntity()) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case HIDE_PLAYER: {
                if (!(event.getEntity() instanceof Player)) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case HIDE_ALL: {
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    private void publishTelemetryUserDetails(@Nullable String remoteAddress) {
        if (!((Boolean)CraftingDeadImmerse.commonConfig.sentryEnabled.get()).booleanValue()) {
            return;
        }
        User session = this.minecraft.m_91094_();
        if (session == null) {
            return;
        }
        io.sentry.protocol.User sentryUser = new io.sentry.protocol.User();
        String username = StringUtils.defaultString((String)session.m_92546_());
        String uuid = StringUtils.defaultString((String)session.m_92545_());
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            sentryUser.setId(uuid);
        } else if (StringUtils.isNotBlank((CharSequence)username)) {
            sentryUser.setId(username);
        }
        if (StringUtils.isNotBlank((CharSequence)username)) {
            sentryUser.setUsername(username);
        }
        sentryUser.setIpAddress("{{auto}}");
        String accountType = session.m_168638_() != null ? session.m_168638_().name() : "UNKNOWN";
        String versionType = (String)StringUtils.defaultIfBlank((CharSequence)this.minecraft.m_91389_(), (CharSequence)"unknown");
        String launchedVersion = (String)StringUtils.defaultIfBlank((CharSequence)this.minecraft.m_91388_(), (CharSequence)"unknown");
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            tags.put("minecraft.username", username);
        }
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            tags.put("minecraft.uuid", uuid);
        }
        tags.put("minecraft.accountType", accountType);
        tags.put("minecraft.versionType", versionType);
        tags.put("minecraft.launcherVersion", launchedVersion);
        tags.put("minecraft.demo", Boolean.toString(this.minecraft.m_91402_()));
        LinkedHashMap<String, String> extras = new LinkedHashMap<String, String>();
        extras.put("minecraft.session.xuid", session.m_193806_().filter(StringUtils::isNotBlank).orElse("unknown"));
        extras.put("minecraft.session.clientId", session.m_193805_().filter(StringUtils::isNotBlank).orElse("unknown"));
        PropertyMap propertyMap = session.m_92548_().getProperties();
        extras.put("minecraft.session.propertyCount", Integer.toString(propertyMap.size()));
        if (!propertyMap.isEmpty()) {
            extras.put("minecraft.session.propertyKeys", String.join((CharSequence)",", propertyMap.keySet()));
        }
        extras.put("minecraft.client.brand", versionType);
        LanguageInfo selectedLanguage = this.minecraft.m_91102_().m_118983_();
        if (selectedLanguage != null) {
            extras.put("minecraft.client.language", selectedLanguage.getCode());
            extras.put("minecraft.client.languageName", selectedLanguage.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)remoteAddress)) {
            extras.put("minecraft.server.remoteAddress", remoteAddress);
        }
        TelemetryManager.updateUser((io.sentry.protocol.User)sentryUser, tags, extras);
    }

    static {
        Animator.setDefaultTimingSource((TimingSource)timingSource);
    }
}

