/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.decoration.data;

import com.craftingdead.decoration.world.level.block.DecorationBlocks;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class DecorationBlockModelProvider
extends BlockModelProvider {
    public DecorationBlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "craftingdeaddecoration", existingFileHelper);
    }

    protected void registerModels() {
        this.modelVariant("oak", "plank_barricade", 3);
        this.modelVariant("spruce", "plank_barricade", 3);
        this.modelVariant("birch", "plank_barricade", 3);
        this.modelVariant("dark_oak", "plank_barricade", 3);
        Set.of("blue", "gray", "green", "red").forEach(color -> {
            this.modelVariant((String)color, "barrel", 2);
            this.modelVariant("worn_" + color, "barrel", 2);
        });
        this.textureVariant(DecorationBlocks.COMPUTER_1, "computer");
        this.textureVariant(DecorationBlocks.COMPUTER_2, "computer");
        this.textureVariant(DecorationBlocks.COMPUTER_3, "computer");
        this.textureVariant(DecorationBlocks.YELLOW_GAS_TANK, "gas_tank");
        this.textureVariant(DecorationBlocks.BLUE_GAS_TANK, "gas_tank");
        this.textureVariant(DecorationBlocks.GRAY_GAS_TANK, "gas_tank");
        this.textureVariant(DecorationBlocks.LAPTOP_1, "laptop");
        this.textureVariant(DecorationBlocks.LAPTOP_2, "laptop");
        this.textureVariant(DecorationBlocks.LAPTOP_3, "laptop");
        this.modelVariant("ripped", "office_chair", 3);
        this.textureVariant(DecorationBlocks.CRACKED_OLD_TELEVISION, "old_television");
        this.textureVariant(DecorationBlocks.CRACKED_TELEVISION, "television");
        this.textureVariant(DecorationBlocks.FULL_TOILET, "toilet");
        this.textureVariant(DecorationBlocks.DIRTY_TOILET, "toilet");
        this.textureVariant(DecorationBlocks.FULL_DIRTY_TOILET, "toilet");
        this.bottomStoreShelfs("box_store_shelf");
        this.bottomStoreShelfs("can_store_shelf");
        this.bottomStoreShelfs("store_shelf");
        this.modelVariant("blue", "gas_can", 3);
        this.modelVariant("green", "gas_can", 3);
        this.modelVariant("red", "gas_can", 3);
        this.textureVariant(DecorationBlocks.AA_POSTER, "poster");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_BLACK, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_BLUE, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_DARKGREEN, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_ORANGE, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_PINK, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_PURPLE, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_RED, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_CLOSED_YELLOW, "sleeping_bag_closed");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_BLACK, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_BLUE, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_DARKGREEN, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_ORANGE, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_PINK, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_PURPLE, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_RED, "sleeping_bag_open");
        this.textureVariant(DecorationBlocks.SLEEPING_BAG_OPEN_YELLOW, "sleeping_bag_open");
    }

    private void bottomStoreShelfs(String model) {
        ResourceLocation texture1 = this.modLoc("block/bottom_store_shelf_1");
        ResourceLocation texture = this.modLoc("block/bottom_store_shelf");
        for (int i = 1; i <= 4; ++i) {
            ResourceLocation tex = i == 1 ? texture1 : texture;
            String name = "%s:block/bottom_%s_%s".formatted("craftingdeaddecoration", model, i);
            this.singleTexture(name, this.modLoc("block/%s_%s".formatted(model, i)), tex);
        }
    }

    private void textureVariant(RegistryObject<? extends Block> block, String model) {
        this.singleTexture(block.getId().toString(), this.modLoc("block/" + model), this.modLoc("block/" + block.getId().m_135815_().toString()));
    }

    private void modelVariant(String variant, String model, int count) {
        this.modelVariant(variant, model, 1, count);
    }

    private void modelVariant(String variant, String model, int from, int to) {
        ResourceLocation texture = this.modLoc("block/%s_%s".formatted(variant, model));
        for (int i = from; i <= to; ++i) {
            String name = "%s:block/%s_%s_%s".formatted("craftingdeaddecoration", variant, model, i);
            this.singleTexture(name, this.modLoc("block/%s_%s".formatted(model, i)), texture);
        }
    }
}

