/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.decoration;

import com.craftingdead.decoration.client.ClientDist;
import com.craftingdead.decoration.data.DecorationBlockModelProvider;
import com.craftingdead.decoration.data.DecorationBlockStateProvider;
import com.craftingdead.decoration.data.DecorationItemModelProvider;
import com.craftingdead.decoration.data.DecorationRecipeProvider;
import com.craftingdead.decoration.data.loot.DecorationLootTableProvider;
import com.craftingdead.decoration.world.item.DecorationItems;
import com.craftingdead.decoration.world.level.block.DecorationBlocks;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

@Mod(value="craftingdeaddecoration")
public class CraftingDeadDecoration {
    public static final String ID = "craftingdeaddecoration";
    private static final String OLD_ID = "cityblocks";
    private static final Logger logger = LogUtils.getLogger();

    public CraftingDeadDecoration() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleGatherData);
        DecorationBlocks.deferredRegister.register(modEventBus);
        DecorationItems.deferredRegister.register(modEventBus);
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, this::handleMissingBlocks);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, this::handleMissingItems);
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new DecorationBlockModelProvider(generator, existingFileHelper));
            generator.m_123914_((DataProvider)new DecorationBlockStateProvider(generator, existingFileHelper));
            generator.m_123914_((DataProvider)new DecorationItemModelProvider(generator, existingFileHelper));
        } else if (event.includeServer()) {
            generator.m_123914_((DataProvider)new DecorationLootTableProvider(generator));
            generator.m_123914_((DataProvider)new DecorationRecipeProvider(generator));
        }
    }

    private void handleMissingItems(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList missingMappings = event.getMappings(OLD_ID);
        for (RegistryEvent.MissingMappings.Mapping mapping : missingMappings) {
            ResourceLocation newKey = new ResourceLocation(ID, mapping.key.m_135815_());
            Item newValue = (Item)ForgeRegistries.ITEMS.getValue(newKey);
            if (newValue == null || newValue == Items.f_41852_) {
                throw new IllegalStateException("Failed to re-map: " + mapping.key.toString());
            }
            mapping.remap((IForgeRegistryEntry)newValue);
            logger.info("Remapped item {} -> {}/{}", new Object[]{mapping.key, newKey, newValue});
        }
    }

    private void handleMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        ImmutableList missingMappings = event.getMappings(OLD_ID);
        for (RegistryEvent.MissingMappings.Mapping mapping : missingMappings) {
            ResourceLocation newKey = new ResourceLocation(ID, mapping.key.m_135815_());
            Block newValue = (Block)ForgeRegistries.BLOCKS.getValue(newKey);
            if (newValue == null || newValue == Blocks.f_50016_) {
                throw new IllegalStateException("Failed to re-map: " + mapping.key.toString());
            }
            mapping.remap((IForgeRegistryEntry)newValue);
            logger.info("Remapped block {} -> {}/{}", new Object[]{mapping.key, newKey, newValue});
        }
    }
}

