/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.decoration.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class DoubleBlock
extends HorizontalDirectionalBlock {
    public static final Property<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);

    protected DoubleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.FIRST)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == DoubleBlock.getNeighbourDirection((Part)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.FIRST ? direction : direction.m_122424_();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos neighborPos;
        BlockState neighborState;
        Part part;
        if (!level.m_5776_() && player.m_7500_() && (part = (Part)((Object)state.m_61143_(PART))) == Part.FIRST && (neighborState = level.m_8055_(neighborPos = pos.m_142300_(DoubleBlock.getNeighbourDirection(part, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && neighborState.m_61143_(PART) == Part.SECOND) {
            level.m_7731_(neighborPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, neighborPos, Block.m_49956_((BlockState)neighborState));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos pos = context.m_8083_();
        BlockPos otherPos = pos.m_142300_(direction);
        Level level = context.m_43725_();
        return level.m_8055_(otherPos).m_60629_(context) && level.m_6857_().m_61937_(otherPos) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack item) {
        super.m_6402_(level, pos, state, entity, item);
        if (!level.m_5776_()) {
            BlockPos otherPos = pos.m_142300_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(otherPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.SECOND)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == Part.FIRST ? facing.m_122424_() : facing;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        return state.m_61143_(PART) == Part.FIRST ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public static enum Part implements StringRepresentable
    {
        FIRST("first"),
        SECOND("second");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

