/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.decoration.world.level.block;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrientableBlock
extends HorizontalDirectionalBlock {
    private final Function<Direction, VoxelShape> shapes;
    private final boolean wallMounted;

    public OrientableBlock(BlockBehaviour.Properties properties, Function<Direction, VoxelShape> shapes) {
        this(properties, shapes, false);
    }

    public OrientableBlock(BlockBehaviour.Properties properties, Function<Direction, VoxelShape> shapes, boolean wallMounted) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
        this.shapes = shapes;
        this.wallMounted = wallMounted;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (!this.wallMounted) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
        }
        BlockState state = this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            Direction opposite;
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)(opposite = direction.m_122424_()))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return state;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.shapes.apply((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!this.wallMounted) {
            return true;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos wallPos = pos.m_142300_(direction.m_122424_());
        BlockState wallState = level.m_8055_(wallPos);
        return wallState.m_60783_((BlockGetter)level, wallPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.wallMounted && direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }
}

