/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.gun.AbstractGun;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunConfiguration;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.AttachmentLike;
import java.util.Optional;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class TypedGun
extends AbstractGun {
    private final GunItem item;
    private GunConfiguration configuration;

    public TypedGun(ItemStack itemStack, GunItem item) {
        super(itemStack);
        this.item = item;
        this.initialize();
    }

    public GunItem getItem() {
        return this.item;
    }

    public GunConfiguration getConfiguration() {
        this.checkInitialized();
        return this.configuration;
    }

    @Override
    protected void initialize() {
        this.configuration = this.item.getConfiguration(CraftingDead.getInstance().getModDist().registryAccess());
        super.initialize();
    }

    @Override
    public boolean isAcceptedAttachment(ItemStack itemStack) {
        return (Boolean)ServerConfig.instance.scopeAttachmentsAllowed.get() != false && itemStack.m_41720_() instanceof AttachmentLike && this.item.getAcceptedAttachments().contains((Object)((AttachmentLike)itemStack.m_41720_()).asAttachment());
    }

    @Override
    public Gun.SecondaryActionTrigger getSecondaryActionTrigger() {
        return this.configuration.getSecondaryActionTrigger();
    }

    @Override
    public Optional<SoundEvent> getReloadSound() {
        return this.configuration.getReloadSound();
    }

    @Override
    public int getReloadDurationTicks() {
        return this.configuration.getReloadDurationTicks();
    }

    @Override
    public Set<? extends Item> getAcceptedMagazines() {
        return this.item.getAcceptedMagazines();
    }

    @Override
    public ItemStack getDefaultMagazineStack() {
        return this.item.getDefaultMagazine().m_7968_();
    }

    @Override
    public CombatSlot getCombatSlot() {
        return this.item.getCombatSlot();
    }

    @Override
    protected boolean canShoot(LivingExtension<?, ?> living) {
        return super.canShoot(living) && this.item.getTriggerPredicate().test(this);
    }

    @Override
    protected float getAccuracy() {
        return this.configuration.getAccuracyPercent();
    }

    @Override
    protected Set<FireMode> getFireModes() {
        return this.configuration.getFireModes();
    }

    @Override
    protected AmmoProvider createAmmoProvider() {
        return this.item.createAmmoProvider();
    }

    @Override
    protected double getRange() {
        return this.configuration.getRange();
    }

    @Override
    protected long getFireDelayMs() {
        return this.configuration.getFireDelayMs();
    }

    @Override
    protected int getRoundsPerShot() {
        return this.configuration.getRoundsPerShot();
    }

    @Override
    protected float getDamage() {
        return this.configuration.getDamage();
    }
}

