/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.world.item.gun.GunConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class GunConfigOverrides {
    private static final Logger logger = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("craftingdead").resolve("guns");
    private static final Map<ResourceLocation, GunConfiguration> overrides = new HashMap<ResourceLocation, GunConfiguration>();
    private static boolean loaded = false;

    public static void loadOverrides() {
        overrides.clear();
        loaded = false;
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                GunConfigOverrides.createExampleConfig();
                logger.info("Created gun config override directory at: {}", (Object)CONFIG_DIR);
            }
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                logger.error("Gun config path exists but is not a directory: {}", (Object)CONFIG_DIR);
                return;
            }
            File[] files = CONFIG_DIR.toFile().listFiles((dir, name) -> name.endsWith(".json"));
            if (files == null || files.length == 0) {
                logger.info("No gun config overrides found");
                loaded = true;
                return;
            }
            int loadedCount = 0;
            for (File file : files) {
                try {
                    String fileName = file.getName();
                    String gunId = fileName.substring(0, fileName.length() - 5);
                    ResourceLocation id = new ResourceLocation("craftingdead", gunId);
                    JsonElement json = JsonParser.parseReader((Reader)new FileReader(file));
                    DataResult result = GunConfiguration.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    if (result.result().isPresent()) {
                        overrides.put(id, (GunConfiguration)((Object)result.result().get()));
                        ++loadedCount;
                        logger.info("Loaded gun config override: {}", (Object)id);
                    }
                    result.error().ifPresent(error -> logger.error("Failed to parse gun config {}: {}", (Object)file.getName(), (Object)error.message()));
                }
                catch (Exception e) {
                    logger.error("Failed to load gun config from {}", (Object)file.getName(), (Object)e);
                }
            }
            logger.info("Loaded {} gun configuration override(s)", (Object)loadedCount);
            loaded = true;
        }
        catch (IOException e) {
            logger.error("Failed to create gun config directory", (Throwable)e);
        }
    }

    public static GunConfiguration getOverride(ResourceLocation id) {
        return overrides.get(id);
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static int getOverrideCount() {
        return overrides.size();
    }

    private static void createExampleConfig() {
        try {
            Path exampleFile = CONFIG_DIR.resolve("_example_ak47.json.disabled");
            String exampleJson = "{\n  \"_comment\": \"This is an example gun configuration override.\",\n  \"_instructions\": \"To use this, rename to 'ak47.json' (remove .disabled extension).\",\n  \"_note\": \"This file overrides the AK47 datapack config. Adjust values as needed.\",\n  \"fire_modes\": [\"auto\", \"semi\"],\n  \"range\": 175.0,\n  \"accuracy_percent\": 0.83,\n  \"recoil\": 3.75,\n  \"fire_delay_ms\": 114.2,\n  \"damage\": 5.5,\n  \"reload_duration_ticks\": 55,\n  \"crosshair_enabled\": true,\n  \"secondary_action_trigger\": \"toggle\",\n  \"sounds\": {\n    \"reload_sound\": \"craftingdead:ak47_reload\",\n    \"shoot_sound\": \"craftingdead:ak47_shoot\",\n    \"distant_shoot_sound\": \"craftingdead:ak47_distant_shoot\",\n    \"silenced_shoot_sound\": \"craftingdead:silenced_ak47_shoot\"\n  }\n}\n";
            Files.writeString(exampleFile, (CharSequence)exampleJson, new OpenOption[0]);
            logger.info("Created example gun config at: {}", (Object)exampleFile);
        }
        catch (IOException e) {
            logger.warn("Failed to create example gun config", (Throwable)e);
        }
    }

    public static GunConfiguration applyOverride(GunConfiguration base, ResourceLocation id) {
        GunConfiguration override = GunConfigOverrides.getOverride(id);
        return override != null ? override : base;
    }

    public static boolean hasOverride(ResourceLocation id) {
        return overrides.containsKey(id);
    }
}

