/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.crafting;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UpgradeMagazineRecipe
extends CustomRecipe {
    private static final int MIDDLE_SLOT_INDEX = 4;
    private final Ingredient magazine;
    private final ItemStack nextTier;

    public UpgradeMagazineRecipe(ResourceLocation id, Ingredient magazine, ItemStack nextTier) {
        super(id);
        this.magazine = magazine;
        this.nextTier = nextTier;
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        block3: for (int i = 0; i < inventory.m_6643_(); ++i) {
            switch (i) {
                case 4: {
                    if (this.magazine.test(inventory.m_8020_(i))) continue block3;
                    return false;
                }
                default: {
                    if (inventory.m_8020_(i).m_204117_(Tags.Items.NUGGETS_IRON)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inventory) {
        Magazine magazine = CapabilityUtil.getOrThrow(Magazine.CAPABILITY, (ICapabilityProvider)inventory.m_8020_(4), Magazine.class);
        CapabilityUtil.getOrThrow(Magazine.CAPABILITY, (ICapabilityProvider)this.nextTier, Magazine.class).setSize(magazine.getSize());
        return this.nextTier;
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 9;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.UPGRADE_MAGAZINE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<UpgradeMagazineRecipe> {
        public UpgradeMagazineRecipe fromJson(ResourceLocation id, JsonObject json) {
            return new UpgradeMagazineRecipe(id, Ingredient.m_43917_((JsonElement)json.get("magazine")), new ItemStack((ItemLike)ShapedRecipe.m_151278_((JsonObject)json.getAsJsonObject("nextTier"))));
        }

        public UpgradeMagazineRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            return new UpgradeMagazineRecipe(id, Ingredient.m_43940_((FriendlyByteBuf)buf), buf.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf buf, UpgradeMagazineRecipe recipe) {
            recipe.magazine.m_43923_(buf);
            buf.m_130055_(recipe.nextTier);
        }
    }
}

