/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.client.animation.Animation;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.RegisterGunColor;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunAnimationEvent;
import com.craftingdead.core.world.item.gun.GunConfigOverrides;
import com.craftingdead.core.world.item.gun.GunConfiguration;
import com.craftingdead.core.world.item.gun.GunConfigurations;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RegisterGunColor
public abstract class GunItem
extends ProjectileWeaponItem {
    private final ResourceKey<GunConfiguration> configurationKey;
    private final Map<GunAnimationEvent, Function<Gun, Animation>> animations;
    private final Set<Supplier<? extends Item>> acceptedMagazines;
    private final Supplier<? extends Item> defaultMagazine;
    private final Set<Supplier<? extends Attachment>> acceptedAttachments;
    private final Predicate<Gun> triggerPredicate;
    private final CombatSlot combatSlot;

    protected GunItem(Builder<?> builder) {
        super(builder.properties);
        this.configurationKey = builder.configurationKey;
        this.animations = builder.animations;
        this.acceptedMagazines = builder.acceptedMagazines;
        this.defaultMagazine = builder.defaultMagazine;
        this.acceptedAttachments = builder.acceptedAttachments;
        this.triggerPredicate = builder.triggerPredicate;
        this.combatSlot = builder.combatSlot;
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return itemStack -> this.getAcceptedMagazines().stream().anyMatch(itemStack.m_41720_()::equals);
    }

    public abstract ICapabilityProvider initCapabilities(ItemStack var1, @Nullable CompoundTag var2);

    public Map<GunAnimationEvent, Function<Gun, Animation>> getAnimations() {
        return this.animations;
    }

    public AmmoProvider createAmmoProvider() {
        return new MagazineAmmoProvider(ItemStack.f_41583_);
    }

    public Set<Item> getAcceptedMagazines() {
        return this.acceptedMagazines.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Item getDefaultMagazine() {
        return this.defaultMagazine.get();
    }

    public Set<Attachment> getAcceptedAttachments() {
        return this.acceptedAttachments.stream().map(Supplier::get).collect(Collectors.toSet());
    }

    public Predicate<Gun> getTriggerPredicate() {
        return this.triggerPredicate;
    }

    public CombatSlot getCombatSlot() {
        return this.combatSlot;
    }

    public GunConfiguration getConfiguration(RegistryAccess registryAccess) {
        return this.getConfiguration((Registry<GunConfiguration>)registryAccess.m_175515_(GunConfigurations.REGISTRY_KEY));
    }

    public GunConfiguration getConfiguration(Registry<GunConfiguration> registry) {
        GunConfiguration baseConfig = (GunConfiguration)((Object)registry.m_6246_(this.configurationKey));
        return GunConfigOverrides.isLoaded() ? GunConfigOverrides.applyOverride(baseConfig, this.configurationKey.m_135782_()) : baseConfig;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, lines, tooltipFlag);
        if (level != null) {
            GunConfiguration configuration = this.getConfiguration(level.m_5962_());
            lines.add(TextComponent.f_131282_);
            lines.add((Component)new TranslatableComponent("gun.stats_header").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            if (configuration.getRoundsPerShot() > 1) {
                MutableComponent pelletsText = new TextComponent(String.valueOf(configuration.getRoundsPerShot())).m_130940_(ChatFormatting.RED);
                lines.add((Component)new TextComponent("\u25c6 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("gun.pellets_shot").m_130940_(ChatFormatting.GRAY).m_7220_((Component)pelletsText)));
            }
            MutableComponent rpmText = new TextComponent(String.valueOf(configuration.getFireRateRPM())).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u00bb ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("gun.rpm").m_130940_(ChatFormatting.GRAY).m_7220_((Component)rpmText)));
            MutableComponent damageText = new TextComponent(String.valueOf(configuration.getDamage())).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u2716 ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TranslatableComponent("gun.damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)damageText)));
            MutableComponent headshotDamageText = new TextComponent(String.valueOf((int)((double)configuration.getDamage() * (Double)ServerConfig.instance.headshotBonusDamage.get()))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25c8 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("gun.headshot_damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)headshotDamageText)));
            MutableComponent accuracyText = new TextComponent((int)(configuration.getAccuracyPercent() * 100.0f) + "%").m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("+ ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TranslatableComponent("gun.accuracy").m_130940_(ChatFormatting.GRAY).m_7220_((Component)accuracyText)));
            MutableComponent rangeText = new TextComponent(configuration.getRange() + " blocks").m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u2500 ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TranslatableComponent("gun.range").m_130940_(ChatFormatting.GRAY).m_7220_((Component)rangeText)));
        }
        itemStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            MutableComponent ammoCount = new TextComponent(String.valueOf(gun.getAmmoProvider().getMagazine().map(Magazine::getSize).orElse(0))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25a0 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("gun.ammo_amount").m_130940_(ChatFormatting.GRAY).m_7220_((Component)ammoCount)));
            for (Attachment attachment : gun.getAttachments().values()) {
                MutableComponent attachmentName = attachment.getDescription().m_6879_().m_130940_(ChatFormatting.RED);
                lines.add((Component)new TextComponent("\u25ca ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("gun.attachment").m_130940_(ChatFormatting.GRAY).m_7220_((Component)attachmentName)));
            }
        });
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44986_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 1;
    }

    public int m_6615_() {
        return 0;
    }

    public static class Builder<SELF extends Builder<SELF>> {
        private final Function<SELF, GunItem> factory;
        private final ResourceKey<GunConfiguration> configurationKey;
        private final Item.Properties properties = new Item.Properties().m_41487_(1).m_41491_(ModItems.COMBAT_TAB);
        private final Set<FireMode> fireModes = EnumSet.noneOf(FireMode.class);
        private final Map<GunAnimationEvent, Function<Gun, Animation>> animations = new EnumMap<GunAnimationEvent, Function<Gun, Animation>>(GunAnimationEvent.class);
        private final Set<Supplier<? extends Item>> acceptedMagazines = new HashSet<Supplier<? extends Item>>();
        private Supplier<? extends Item> defaultMagazine;
        private final Set<Supplier<? extends Attachment>> acceptedAttachments = new HashSet<Supplier<? extends Attachment>>();
        private Predicate<Gun> triggerPredicate = gun -> true;
        private CombatSlot combatSlot = CombatSlot.PRIMARY;

        public Builder(Function<SELF, GunItem> factory, ResourceKey<GunConfiguration> configurationKey) {
            this.factory = factory;
            this.configurationKey = configurationKey;
        }

        public SELF properties(Consumer<Item.Properties> consumer) {
            consumer.accept(this.properties);
            return this.self();
        }

        public SELF addFireMode(FireMode fireMode) {
            this.fireModes.add(fireMode);
            return this.self();
        }

        public SELF putAnimation(GunAnimationEvent event, Supplier<Animation> animation) {
            return this.putAnimation(event, (Gun __) -> (Animation)animation.get());
        }

        public SELF putReloadAnimation(IntFunction<Animation> animation) {
            return this.putAnimation(GunAnimationEvent.RELOAD, (Gun gun) -> (Animation)animation.apply(gun.getReloadDurationTicks()));
        }

        public SELF putAnimation(GunAnimationEvent event, Function<Gun, Animation> animation) {
            this.animations.put(event, animation);
            return this.self();
        }

        public SELF addAcceptedMagazine(Supplier<? extends Item> acceptedMagazine) {
            this.acceptedMagazines.add(acceptedMagazine);
            return this.self();
        }

        public SELF setDefaultMagazine(Supplier<? extends Item> defaultMagazine) {
            if (this.defaultMagazine != null) {
                throw new IllegalArgumentException("Default magazine already set");
            }
            this.defaultMagazine = defaultMagazine;
            return this.addAcceptedMagazine(defaultMagazine);
        }

        public SELF addAcceptedAttachment(Supplier<? extends Attachment> acceptedAttachment) {
            this.acceptedAttachments.add(acceptedAttachment);
            return this.self();
        }

        public SELF setTriggerPredicate(Predicate<Gun> triggerPredicate) {
            this.triggerPredicate = triggerPredicate;
            return this.self();
        }

        public SELF setCombatSlot(CombatSlot combatSlot) {
            this.combatSlot = combatSlot;
            return this.self();
        }

        public GunItem build() {
            return this.factory.apply(this.self());
        }

        protected final SELF self() {
            return (SELF)this;
        }
    }
}

