/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.util.FunctionalUtil;
import com.craftingdead.core.world.item.gun.AimAttributes;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class GunConfiguration
extends ForgeRegistryEntry<GunConfiguration> {
    public static final Codec<GunConfiguration> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fire_delay_ms").forGetter(GunConfiguration::getFireDelayMs), (App)Codec.FLOAT.fieldOf("damage").forGetter(GunConfiguration::getDamage), (App)Codec.INT.fieldOf("reload_duration_ticks").forGetter(GunConfiguration::getReloadDurationTicks), (App)Codec.FLOAT.fieldOf("accuracy_percent").forGetter(GunConfiguration::getAccuracyPercent), (App)Codec.FLOAT.fieldOf("recoil").forGetter(GunConfiguration::getRecoil), (App)Codec.INT.optionalFieldOf("rounds_per_shot", (Object)1).forGetter(GunConfiguration::getRoundsPerShot), (App)Codec.DOUBLE.fieldOf("range").forGetter(GunConfiguration::getRange), (App)Codec.BOOL.optionalFieldOf("crosshair_enabled", (Object)true).forGetter(GunConfiguration::isCrosshairEnabled), (App)Gun.SecondaryActionTrigger.CODEC.fieldOf("secondary_action_trigger").forGetter(GunConfiguration::getSecondaryActionTrigger), (App)Codec.list(FireMode.CODEC).optionalFieldOf("fire_modes", List.of(FireMode.SEMI)).xmap(ImmutableSet::copyOf, ArrayList::new).forGetter(GunConfiguration::getFireModes), (App)AimAttributes.CODEC.optionalFieldOf("aim_settings").forGetter(GunConfiguration::getAimSettings), (App)Sounds.CODEC.fieldOf("sounds").forGetter(GunConfiguration::getSounds)).apply((Applicative)instance, GunConfiguration::new));
    private final int fireDelayMs;
    private final float damage;
    private final int reloadDurationTicks;
    private final float accuracyPercent;
    private final float recoil;
    private final int roundsPerShot;
    private final double range;
    private final boolean crosshairEnabled;
    private final Gun.SecondaryActionTrigger secondaryActionTrigger;
    private final Set<FireMode> fireModes;
    private final Optional<AimAttributes> aimAttributes;
    private final Sounds sounds;

    public GunConfiguration(int fireDelayMs, float damage, int reloadDurationTicks, float accuracyPercent, float recoil, int roundsPerShot, double range, boolean crosshairVisible, Gun.SecondaryActionTrigger secondaryActionTrigger, Set<FireMode> fireModes, Optional<AimAttributes> aimAttributes, Sounds sounds) {
        this.fireDelayMs = fireDelayMs;
        this.damage = damage;
        this.reloadDurationTicks = reloadDurationTicks;
        this.accuracyPercent = accuracyPercent;
        this.recoil = recoil;
        this.roundsPerShot = roundsPerShot;
        this.range = range;
        this.crosshairEnabled = crosshairVisible;
        this.secondaryActionTrigger = secondaryActionTrigger;
        this.fireModes = fireModes;
        this.aimAttributes = aimAttributes;
        this.sounds = sounds;
    }

    public int getFireDelayMs() {
        return this.fireDelayMs;
    }

    public int getFireRateRPM() {
        return 60000 / this.getFireDelayMs();
    }

    public float getDamage() {
        return this.damage;
    }

    public int getReloadDurationTicks() {
        return this.reloadDurationTicks;
    }

    public float getAccuracyPercent() {
        return this.accuracyPercent;
    }

    public float getRecoil() {
        return this.recoil;
    }

    public int getRoundsPerShot() {
        return this.roundsPerShot;
    }

    public double getRange() {
        return this.range;
    }

    public boolean isCrosshairEnabled() {
        return this.crosshairEnabled;
    }

    public Gun.SecondaryActionTrigger getSecondaryActionTrigger() {
        return this.secondaryActionTrigger;
    }

    public Set<FireMode> getFireModes() {
        return this.fireModes;
    }

    public Optional<AimAttributes> getAimSettings() {
        return this.aimAttributes;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public SoundEvent getShootSound() {
        return this.sounds.shootSound().get();
    }

    public Optional<SoundEvent> getDistantShootSound() {
        return Optional.ofNullable(this.sounds.distantShootSound()).map(Supplier::get);
    }

    public Optional<SoundEvent> getSilencedShootSound() {
        return Optional.ofNullable(this.sounds.silencedShootSound()).map(Supplier::get);
    }

    public Optional<SoundEvent> getReloadSound() {
        return Optional.ofNullable(this.sounds.reloadSound()).map(Supplier::get);
    }

    public Optional<SoundEvent> getSecondaryActionSound() {
        return FunctionalUtil.optional(this.sounds.secondaryActionSound);
    }

    public long getSecondaryActionSoundRepeatDelayMs() {
        return this.sounds.secondaryActionSoundRepeatDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public record Sounds(Supplier<SoundEvent> shootSound, Supplier<SoundEvent> distantShootSound, Supplier<SoundEvent> silencedShootSound, Supplier<SoundEvent> reloadSound, Supplier<SoundEvent> secondaryActionSound, long secondaryActionSoundRepeatDelay) {
        public static final Codec<Sounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.SOUND_EVENTS.getCodec().fieldOf("shoot_sound").xmap(FunctionalUtil::supplier, Supplier::get).forGetter(Sounds::shootSound), (App)ForgeRegistries.SOUND_EVENTS.getCodec().optionalFieldOf("distant_shoot_sound", null).xmap(FunctionalUtil::supplier, Supplier::get).forGetter(Sounds::distantShootSound), (App)ForgeRegistries.SOUND_EVENTS.getCodec().optionalFieldOf("silenced_shoot_sound", null).xmap(FunctionalUtil::supplier, Supplier::get).forGetter(Sounds::silencedShootSound), (App)ForgeRegistries.SOUND_EVENTS.getCodec().optionalFieldOf("reload_sound", null).xmap(FunctionalUtil::supplier, Supplier::get).forGetter(Sounds::reloadSound), (App)ForgeRegistries.SOUND_EVENTS.getCodec().optionalFieldOf("secondary_action_sound", null).xmap(FunctionalUtil::supplier, Supplier::get).forGetter(Sounds::secondaryActionSound), (App)Codec.LONG.optionalFieldOf("secondary_action_sound_repeat_delay", (Object)-1L).forGetter(Sounds::secondaryActionSoundRepeatDelay)).apply((Applicative)instance, Sounds::new));
    }

    public static class Builder {
        private int fireDelayMs;
        private float damage;
        private int reloadDurationTicks;
        private int roundsPerShot = 1;
        private float accuracyPercent;
        private float recoil;
        private double range;
        private boolean crosshairEnabled = true;
        private Gun.SecondaryActionTrigger rightMouseActionTriggerType = Gun.SecondaryActionTrigger.TOGGLE;
        private final Set<FireMode> fireModes = EnumSet.noneOf(FireMode.class);
        @Nullable
        private AimAttributes aimAttributes;
        private Supplier<SoundEvent> shootSound;
        private Supplier<SoundEvent> distantShootSound = () -> null;
        private Supplier<SoundEvent> silencedShootSound = () -> null;
        private Supplier<SoundEvent> reloadSound = () -> null;
        private Supplier<SoundEvent> secondaryActionSound = () -> null;
        private long secondaryActionSoundRepeatDelayMs = -1L;

        public Builder setFireDelayMs(int fireDelayMs) {
            this.fireDelayMs = fireDelayMs;
            return this;
        }

        public Builder setDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder setReloadDurationTicks(int reloadDurationTicks) {
            this.reloadDurationTicks = reloadDurationTicks;
            return this;
        }

        public Builder setRoundsPerShot(int roundsPerShot) {
            this.roundsPerShot = roundsPerShot;
            return this;
        }

        public Builder setCrosshairEnabled(boolean crosshairEnabled) {
            this.crosshairEnabled = crosshairEnabled;
            return this;
        }

        public Builder setAccuracy(float accuracy) {
            this.accuracyPercent = accuracy;
            return this;
        }

        public Builder setRecoil(float recoil) {
            this.recoil = recoil;
            return this;
        }

        public Builder setRange(double range) {
            this.range = range;
            return this;
        }

        public Builder setRightMouseActionTriggerType(Gun.SecondaryActionTrigger rightMouseActionTriggerType) {
            this.rightMouseActionTriggerType = rightMouseActionTriggerType;
            return this;
        }

        public Builder addFireMode(FireMode fireMode) {
            this.fireModes.add(fireMode);
            return this;
        }

        public Builder aimable(boolean boltAction) {
            this.aimAttributes = new AimAttributes(boltAction);
            return this;
        }

        public Builder setShootSound(Supplier<SoundEvent> shootSound) {
            this.shootSound = shootSound;
            return this;
        }

        public Builder setDistantShootSound(Supplier<SoundEvent> distantShootSound) {
            this.distantShootSound = distantShootSound;
            return this;
        }

        public Builder setSilencedShootSound(Supplier<SoundEvent> silencedShootSound) {
            this.silencedShootSound = silencedShootSound;
            return this;
        }

        public Builder setReloadSound(Supplier<SoundEvent> reloadSound) {
            this.reloadSound = reloadSound;
            return this;
        }

        public Builder setSecondaryActionSound(Supplier<SoundEvent> secondaryActionSound) {
            this.secondaryActionSound = secondaryActionSound;
            return this;
        }

        public Builder setSecondaryActionSoundRepeatDelayMs(long secondaryActionSoundRepeatDelayMs) {
            this.secondaryActionSoundRepeatDelayMs = secondaryActionSoundRepeatDelayMs;
            return this;
        }

        public GunConfiguration build() {
            return new GunConfiguration(this.fireDelayMs, this.damage, this.reloadDurationTicks, this.accuracyPercent, this.recoil, this.roundsPerShot, this.range, this.crosshairEnabled, this.rightMouseActionTriggerType, this.fireModes, Optional.ofNullable(this.aimAttributes), new Sounds(this.shootSound, this.distantShootSound, this.silencedShootSound, this.reloadSound, this.secondaryActionSound, this.secondaryActionSoundRepeatDelayMs));
        }
    }
}

