/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.equipment;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClothingProtection {
    private static final String BITE_PROTECTION_TAG = "BiteProtection";
    private static final String STAB_RESISTANCE_TAG = "StabResistance";
    private static final String BLUNT_RESISTANCE_TAG = "BluntResistance";
    private static final String WEIGHT_MODIFIER_TAG = "WeightModifier";
    private static final String CLOTHING_TIER_TAG = "ClothingTier";

    public static float getBiteProtection(@NotNull ItemStack itemStack) {
        if (itemStack.m_41619_() || !itemStack.m_41782_()) {
            return 0.0f;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128457_(BITE_PROTECTION_TAG) : 0.0f;
    }

    public static float getStabResistance(@NotNull ItemStack itemStack) {
        if (itemStack.m_41619_() || !itemStack.m_41782_()) {
            return 0.0f;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128457_(STAB_RESISTANCE_TAG) : 0.0f;
    }

    public static float getBluntResistance(@NotNull ItemStack itemStack) {
        if (itemStack.m_41619_() || !itemStack.m_41782_()) {
            return 0.0f;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128457_(BLUNT_RESISTANCE_TAG) : 0.0f;
    }

    public static float getWeightModifier(@NotNull ItemStack itemStack) {
        if (itemStack.m_41619_() || !itemStack.m_41782_()) {
            return 0.0f;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128457_(WEIGHT_MODIFIER_TAG) : 0.0f;
    }

    public static String getClothingTier(@NotNull ItemStack itemStack) {
        if (itemStack.m_41619_() || !itemStack.m_41782_()) {
            return "casual";
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? tag.m_128461_(CLOTHING_TIER_TAG) : "casual";
    }

    public static void setBiteProtection(@NotNull ItemStack itemStack, float protection) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128350_(BITE_PROTECTION_TAG, ClothingProtection.clamp(protection, 0.0f, 1.0f));
    }

    public static void setStabResistance(@NotNull ItemStack itemStack, float resistance) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128350_(STAB_RESISTANCE_TAG, ClothingProtection.clamp(resistance, 0.0f, 1.0f));
    }

    public static void setBluntResistance(@NotNull ItemStack itemStack, float resistance) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128350_(BLUNT_RESISTANCE_TAG, ClothingProtection.clamp(resistance, 0.0f, 1.0f));
    }

    public static void setWeightModifier(@NotNull ItemStack itemStack, float weight) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128350_(WEIGHT_MODIFIER_TAG, ClothingProtection.clamp(weight, -1.0f, 1.0f));
    }

    public static void setClothingTier(@NotNull ItemStack itemStack, String tier) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(CLOTHING_TIER_TAG, tier);
    }

    public static void applyProtectionAttributes(@NotNull ItemStack itemStack, float biteProtection, float stabResistance, float bluntResistance, float weightModifier, String tier) {
        ClothingProtection.setBiteProtection(itemStack, biteProtection);
        ClothingProtection.setStabResistance(itemStack, stabResistance);
        ClothingProtection.setBluntResistance(itemStack, bluntResistance);
        ClothingProtection.setWeightModifier(itemStack, weightModifier);
        ClothingProtection.setClothingTier(itemStack, tier);
    }

    public static float calculateInfectionChance(float baseInfectionChance, float biteProtection) {
        return baseInfectionChance * (1.0f - biteProtection);
    }

    public static float calculateBleedChance(float baseBleedChance, float stabResistance) {
        return baseBleedChance * (1.0f - stabResistance);
    }

    public static float calculateFinalDamage(float baseDamage, float bluntResistance) {
        return baseDamage * (1.0f - bluntResistance);
    }

    public static boolean hasProtectionAttributes(@NotNull ItemStack itemStack) {
        return ClothingProtection.getBiteProtection(itemStack) > 0.0f || ClothingProtection.getStabResistance(itemStack) > 0.0f || ClothingProtection.getBluntResistance(itemStack) > 0.0f || Math.abs(ClothingProtection.getWeightModifier(itemStack)) > 0.001f;
    }

    private static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }
}

