/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.util;

import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalUtil {
    public static <T> Optional<T> optional(@Nullable Supplier<T> supplier) {
        return Optional.ofNullable(supplier).map(Supplier::get);
    }

    public static <T> Supplier<T> supplier(@NotNull T instance) {
        return Suppliers.ofInstance(instance);
    }

    public static <T> Supplier<T> supply(T value) {
        return () -> value;
    }

    public static <T, U, R> BiFunction<@Nullable T, U, R> nullsafeFunction(BiFunction<@NotNull T, U, R> original, Function<U, R> fallback) {
        return (arg1, arg2) -> {
            if (arg1 == null) {
                return fallback.apply(arg2);
            }
            return original.apply(arg1, arg2);
        };
    }
}

