/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.animation.gun;

import com.craftingdead.core.client.animation.TimedAnimation;
import com.craftingdead.core.util.EasingFunction;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class ShootAnimation
extends TimedAnimation {
    private final float bounceAmplification;
    private final float kickbackAmplification;

    public ShootAnimation(int lifetimeTicks, float bounceAmplification, float kickbackAmplification) {
        super(lifetimeTicks);
        this.bounceAmplification = bounceAmplification;
        this.kickbackAmplification = kickbackAmplification;
    }

    @Override
    public void apply(float partialTick, PoseStack poseStack) {
        float percent = this.lerpProgress(partialTick);
        float kickback = this.getKickbackTranslation(percent);
        float sideRecoil = 0.01f * Mth.m_14031_((float)(percent * (float)Math.PI));
        poseStack.m_85837_((double)sideRecoil, 0.0, (double)kickback);
        Quaternion rotation = this.getRecoilRotation(percent);
        poseStack.m_85845_(rotation);
    }

    private Quaternion getRecoilRotation(float percent) {
        float easedBounce = EasingFunction.SINE_IN.andThen(EasingFunction.ELASTIC_OUT).apply(percent);
        float xRot = this.bounceAmplification * Mth.m_14031_((float)(easedBounce * (float)Math.PI));
        float yRot = this.bounceAmplification * 0.1f * Mth.m_14031_((float)(easedBounce * (float)Math.PI * 2.0f));
        float zRot = this.bounceAmplification * 0.05f * Mth.m_14031_((float)(easedBounce * (float)Math.PI * 2.0f));
        Quaternion q = Vector3f.f_122223_.m_122240_(xRot);
        q.m_80148_(Vector3f.f_122225_.m_122240_(yRot));
        q.m_80148_(Vector3f.f_122227_.m_122240_(zRot));
        return q;
    }

    private float getKickbackTranslation(float percent) {
        float easedProgress = EasingFunction.EXPO_OUT.apply(percent);
        return Mth.m_14031_((float)(easedProgress * (float)Math.PI)) * this.kickbackAmplification;
    }

    @Override
    public void applyArm(InteractionHand hand, HumanoidArm arm, float partialTick, PoseStack poseStack) {
        float lerpProgress = this.lerpProgress(partialTick);
        float translation = this.getKickbackTranslation(lerpProgress);
        float armAngle = 2.5f * Mth.m_14031_((float)(lerpProgress * (float)Math.PI));
        switch (arm) {
            case LEFT: {
                poseStack.m_85837_(0.0, (double)(-translation * 0.25f), (double)(translation * 0.5f));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-armAngle));
                break;
            }
            case RIGHT: {
                poseStack.m_85837_(0.0, 0.0, (double)translation);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-armAngle));
            }
        }
    }

    @Override
    public void applyCamera(float partialTick, Vector3f rotations) {
        float percent = this.lerpProgress(partialTick);
        float deltaX = 0.5f * Mth.m_14031_((float)(percent * (float)Math.PI));
        float deltaY = 0.2f * Mth.m_14031_((float)(percent * (float)Math.PI * 2.0f));
        rotations.m_122272_(deltaX, deltaY, 0.0f);
    }

    public static ShootAnimation rifle() {
        return new ShootAnimation(5, 1.25f, 0.1f);
    }

    public static ShootAnimation boltActionSniper() {
        return new ShootAnimation(16, 3.25f, 0.4f);
    }

    public static ShootAnimation autoSniper() {
        return new ShootAnimation(6, 3.25f, 0.65f);
    }

    public static ShootAnimation submachineGun() {
        return new ShootAnimation(5, 2.0f, 0.15f);
    }

    public static ShootAnimation pistol() {
        return new ShootAnimation(7, 3.5f, 0.5f);
    }

    public static ShootAnimation shotGun() {
        return new ShootAnimation(13, 3.0f, 0.4f);
    }
}

