/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record EntitySnapshot(Vec3 position, AABB boundingBox, Vec2 rotation, Vec3 velocity, boolean crouching, float eyeHeight, boolean complete) {
    public EntitySnapshot(Vec3 position, AABB boundingBox, Vec2 rotation, Vec3 velocity, boolean crouching) {
        this(position, boundingBox, rotation, velocity, crouching, -1.0f, false);
    }

    public EntitySnapshot combineUntrustedSnapshot(EntitySnapshot snapshot) {
        if (!this.complete) {
            throw new UnsupportedOperationException("Snapshot not complete");
        }
        Vec3 position = snapshot.position;
        if (this.position.m_82554_(snapshot.position) > 1.0) {
            position = this.position;
        }
        AABB boundingBox = snapshot.boundingBox;
        if (Math.abs(this.boundingBox.m_82309_() - snapshot.boundingBox.m_82309_()) > 1.0E-10) {
            boundingBox = this.boundingBox;
        }
        Vec2 rotation = snapshot.rotation;
        if ((double)Mth.m_14145_((float)this.rotation.f_82470_, (float)snapshot.rotation.f_82470_) > 10.0 || (double)Mth.m_14145_((float)this.rotation.f_82471_, (float)snapshot.rotation.f_82471_) > 10.0) {
            rotation = this.rotation;
        }
        Vec3 deltaMovement = snapshot.velocity;
        if (this.velocity.m_82554_(snapshot.velocity) > 0.1) {
            deltaMovement = this.velocity;
        }
        return new EntitySnapshot(position, boundingBox, rotation, deltaMovement, snapshot.crouching, this.eyeHeight, true);
    }

    public void encode(FriendlyByteBuf out) {
        out.writeDouble(this.position.m_7096_());
        out.writeDouble(this.position.m_7098_());
        out.writeDouble(this.position.m_7094_());
        out.writeDouble(this.boundingBox.f_82288_);
        out.writeDouble(this.boundingBox.f_82289_);
        out.writeDouble(this.boundingBox.f_82290_);
        out.writeDouble(this.boundingBox.f_82291_);
        out.writeDouble(this.boundingBox.f_82292_);
        out.writeDouble(this.boundingBox.f_82293_);
        out.writeFloat(this.rotation.f_82470_);
        out.writeFloat(this.rotation.f_82471_);
        out.writeDouble(this.velocity.f_82479_);
        out.writeDouble(this.velocity.f_82480_);
        out.writeDouble(this.velocity.f_82481_);
        out.writeBoolean(this.crouching);
    }

    public static EntitySnapshot decode(FriendlyByteBuf in) {
        Vec3 position = new Vec3(in.readDouble(), in.readDouble(), in.readDouble());
        double minX = in.readDouble();
        double minY = in.readDouble();
        double minZ = in.readDouble();
        double maxX = in.readDouble();
        double maxY = in.readDouble();
        double maxZ = in.readDouble();
        Vec2 rotation = new Vec2(in.readFloat(), in.readFloat());
        Vec3 velocity = new Vec3(in.readDouble(), in.readDouble(), in.readDouble());
        return new EntitySnapshot(position, new AABB(minX, minY, minZ, maxX, maxY, maxZ), rotation, velocity, in.readBoolean());
    }
}

