/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.capability;

import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;
import org.jetbrains.annotations.Nullable;

class SimpleCapabilityProvider<C>
implements ICapabilityProvider {
    protected final LazyOptional<C> instance;
    protected final Set<Capability<? super C>> capabilities;
    @Nullable
    protected final NonNullFunction<C, ICapabilityProvider> instanceMapper;

    public SimpleCapabilityProvider(LazyOptional<C> instance, Set<Capability<? super C>> capabilities, @Nullable NonNullFunction<C, ICapabilityProvider> instanceMapper) {
        this.instance = instance;
        this.capabilities = capabilities;
        this.instanceMapper = instanceMapper;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.capabilities.contains(cap)) {
            return this.instance.cast();
        }
        if (this.instanceMapper != null) {
            return (LazyOptional)this.instance.lazyMap(this.instanceMapper).lazyMap(provider -> provider.getCapability(cap, side)).orElse((Object)LazyOptional.empty());
        }
        return LazyOptional.empty();
    }
}

