/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.inventory.EquipmentSlot;
import com.craftingdead.core.world.inventory.GunCraftSlot;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.inventory.PredicateSlot;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.attachment.AttachmentLike;
import com.craftingdead.core.world.item.gun.skin.Paint;
import java.util.function.BiPredicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EquipmentMenu
extends AbstractContainerMenu {
    private final ResultContainer outputContainer = new ResultContainer();
    private final SimpleContainer craftingContainer = new SimpleContainer(4);
    private final PlayerExtension<?> player;

    public EquipmentMenu(int id, Inventory inventory) {
        this(id, PlayerExtension.getOrThrow(inventory.f_35978_));
    }

    public EquipmentMenu(int id, PlayerExtension<?> player) {
        super((MenuType)ModMenuTypes.EQUIPMENT.get(), id);
        this.player = player;
        this.craftingContainer.m_19164_(arg_0 -> ((EquipmentMenu)this).m_6199_(arg_0));
        Inventory inventory = ((Player)player.entity()).m_150109_();
        int slotSize = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + (y + 1) * 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 141));
        }
        int equipmentColumnX = 77;
        int equipmentColumnY = 8;
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.HAT, equipmentColumnX, equipmentColumnY));
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.CLOTHING, equipmentColumnX, equipmentColumnY += 18));
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.VEST, equipmentColumnX, equipmentColumnY += 18));
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.BACKPACK, equipmentColumnX, equipmentColumnY + 18));
        int weaponColumnX = 8;
        int weaponColumnY = 8;
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.GUN, weaponColumnX, weaponColumnY));
        this.m_38897_(new EquipmentSlot(player, Equipment.Slot.MELEE, weaponColumnX, weaponColumnY + 18));
        int gunCraftSlotGap = 2;
        int gunCraftY = 6;
        int gunCraftX = 115;
        this.m_38897_(new GunCraftSlot(this.outputContainer, 0, 135, 26, this.craftingContainer));
        BiPredicate<PredicateSlot, ItemStack> attachmentOrPaintPredicate = (slot, itemStack) -> this.getGunStack().getCapability(Gun.CAPABILITY).map(gun -> gun.isAcceptedAttachment((ItemStack)itemStack)).orElse(false);
        BiPredicate<PredicateSlot, ItemStack> attachmentPredicate = (slot, itemStack) -> itemStack.m_41720_() instanceof AttachmentLike && ((AttachmentLike)itemStack.m_41720_()).asAttachment().getInventorySlot().getIndex() == slot.getSlotIndex();
        this.m_38897_(new PredicateSlot((Container)this.craftingContainer, GunCraftSlotType.MUZZLE_ATTACHMENT.getIndex(), 115, 26, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.m_38897_(new PredicateSlot((Container)this.craftingContainer, GunCraftSlotType.UNDERBARREL_ATTACHMENT.getIndex(), 135, 46, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.m_38897_(new PredicateSlot((Container)this.craftingContainer, GunCraftSlotType.OVERBARREL_ATTACHMENT.getIndex(), 135, 6, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.m_38897_(new PredicateSlot((Container)this.craftingContainer, GunCraftSlotType.PAINT.getIndex(), 155, 26, (slot, itemStack) -> Paint.isValid(this.getGunStack(), itemStack)));
    }

    public PlayerExtension<?> getPlayer() {
        return this.player;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_183503_().m_5776_()) {
            this.m_150411_(player, (Container)this.craftingContainer);
            this.m_150411_(player, (Container)this.outputContainer);
        }
    }

    public ItemStack getGunStack() {
        return this.outputContainer.m_8020_(0);
    }

    public boolean isCraftingInventoryEmpty() {
        return this.craftingContainer.m_7983_();
    }

    public boolean isCraftable() {
        return this.getGunStack().getCapability(Gun.CAPABILITY).map(gun -> {
            for (int i = 0; i < this.craftingContainer.m_6643_(); ++i) {
                ItemStack itemStack = this.craftingContainer.m_8020_(i);
                if (itemStack.m_41619_() || gun.isAcceptedAttachment(itemStack) || Paint.isValid(this.getGunStack(), itemStack)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public ItemStack m_7648_(Player playerEntity, int clickedIndex) {
        Slot clickedSlot = (Slot)this.f_38839_.get(clickedIndex);
        if (clickedSlot != null && clickedSlot.m_6657_()) {
            if (clickedSlot instanceof GunCraftSlot) {
                return ItemStack.f_41583_;
            }
            ItemStack clickedStack = clickedSlot.m_7993_();
            if (clickedIndex < 36 ? !this.m_38903_(clickedStack, 36, this.f_38839_.size(), true) : !this.m_38903_(clickedStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                clickedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                clickedSlot.m_6654_();
            }
        }
        return ItemStack.f_41583_;
    }
}

