/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.server.updater;

import com.mojang.logging.LogUtils;
import java.io.File;
import org.slf4j.Logger;

public class ServerRestartHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int RESTART_EXIT_CODE = 2;

    public static void triggerRestart() {
        LOGGER.info("==========================================================");
        LOGGER.info("    CRAFTING DEAD AUTO-UPDATER: RESTART REQUIRED");
        LOGGER.info("==========================================================");
        LOGGER.info("Mod updates have been installed.");
        LOGGER.info("Server will now restart to apply changes...");
        LOGGER.info("==========================================================");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        LOGGER.info("Exiting with restart code: {}", (Object)2);
        System.exit(2);
    }

    public static void triggerRestartDelayed(int delaySeconds) {
        LOGGER.info("Server will restart in {} seconds...", (Object)delaySeconds);
        new Thread(() -> {
            try {
                for (int i = delaySeconds; i > 0; --i) {
                    LOGGER.info("Restarting in {} second(s)...", (Object)i);
                    Thread.sleep(1000L);
                }
                ServerRestartHandler.triggerRestart();
            }
            catch (InterruptedException e) {
                LOGGER.error("Restart timer interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }, "ServerRestart-Timer").start();
    }

    public static boolean canAutoRestart() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return ServerRestartHandler.checkWindowsWrapper();
        }
        if (osName.contains("linux")) {
            return ServerRestartHandler.checkLinuxEnvironment();
        }
        return false;
    }

    private static boolean checkWindowsWrapper() {
        String restartVar = System.getenv("ENABLE_RESTART");
        if ("true".equalsIgnoreCase(restartVar)) {
            LOGGER.debug("Windows restart wrapper detected (ENABLE_RESTART=true)");
            return true;
        }
        try {
            String command;
            ProcessHandle current = ProcessHandle.current();
            ProcessHandle parent = current.parent().orElse(null);
            if (parent != null && ((command = parent.info().command().orElse("")).contains("cmd.exe") || command.contains("powershell"))) {
                LOGGER.debug("Windows shell parent detected: {}", (Object)command);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not detect parent process", (Throwable)e);
        }
        return false;
    }

    private static boolean checkLinuxEnvironment() {
        String[] panelVars;
        if (System.getenv("INVOCATION_ID") != null) {
            LOGGER.debug("Systemd environment detected");
            return true;
        }
        if (new File("/.dockerenv").exists()) {
            LOGGER.debug("Docker environment detected");
            return true;
        }
        for (String var : panelVars = new String[]{"PTERODACTYL", "PUFFERPANEL", "MULTICRAFT_SERVER_ID"}) {
            if (System.getenv(var) == null) continue;
            LOGGER.debug("Server panel environment detected: {}", (Object)var);
            return true;
        }
        return false;
    }

    public static void printManualRestartInstructions() {
        LOGGER.warn("==========================================================");
        LOGGER.warn("    MANUAL RESTART REQUIRED");
        LOGGER.warn("==========================================================");
        LOGGER.warn("Mod updates have been installed.");
        LOGGER.warn("Please restart the server manually to apply changes.");
        LOGGER.warn("");
        LOGGER.warn("To enable auto-restart, see:");
        LOGGER.warn("  docs/SERVER_UPDATER_README.md");
        LOGGER.warn("==========================================================");
    }
}

