/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import com.craftingdead.core.client.gui.SimpleButton;
import com.craftingdead.core.client.updater.ModAutoUpdater;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class UpdatePromptScreen
extends Screen {
    private final Screen parent;
    private final Map<String, ModAutoUpdater.UpdateInfo> availableUpdates;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int TEXT_COLOR = 0xAAAAAA;
    private static final int HIGHLIGHT_COLOR = 0x55FF55;

    public UpdatePromptScreen(Screen parent, Map<String, ModAutoUpdater.UpdateInfo> availableUpdates) {
        super((Component)new TextComponent("Mod Updates Available"));
        this.parent = parent;
        this.availableUpdates = availableUpdates;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonY = this.f_96544_ / 2 + 70;
        int buttonSpacing = 110;
        this.m_142416_((GuiEventListener)new SimpleButton(this.f_96543_ / 2 - buttonSpacing, buttonY, 100, 20, (Component)new TextComponent("Yes"), button -> {
            ModAutoUpdater.downloadAllUpdates();
            this.f_96541_.m_91152_(this.parent);
        }));
        this.m_142416_((GuiEventListener)new SimpleButton(this.f_96543_ / 2 + 10, buttonY, 100, 20, (Component)new TextComponent("No"), button -> this.f_96541_.m_91152_(this.parent)));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 90), (int)0xFFFFFF);
        TextComponent message = new TextComponent("Updates are available for the following mods:");
        UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)message, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 70), (int)0xAAAAAA);
        int yOffset = this.f_96544_ / 2 - 50;
        int count = 0;
        for (Map.Entry<String, ModAutoUpdater.UpdateInfo> entry : this.availableUpdates.entrySet()) {
            if (count >= 5) {
                TextComponent moreText = new TextComponent("... and " + (this.availableUpdates.size() - 5) + " more");
                UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)moreText, (int)(this.f_96543_ / 2), (int)yOffset, (int)0xAAAAAA);
                break;
            }
            String modId = entry.getKey();
            ModAutoUpdater.UpdateInfo info = entry.getValue();
            String updateText = String.format("\u2022 %s: %s \u2192 %s", modId, info.localVersion.version, info.remoteVersion);
            TextComponent modText = new TextComponent(updateText);
            UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)modText, (int)(this.f_96543_ / 2), (int)yOffset, (int)0x55FF55);
            yOffset += 12;
            ++count;
        }
        TextComponent question = new TextComponent("Would you like to download and install these updates?");
        UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)question, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 45), (int)0xAAAAAA);
        TextComponent note = new TextComponent("(Minecraft will need to be restarted after download)");
        UpdatePromptScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)note, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 57), (int)0x888888);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }
}

