/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.magazine;

import com.craftingdead.core.world.item.MagazineItem;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class MagazineImpl
implements Magazine {
    private final MagazineItem magazineItem;
    private final AtomicInteger size;
    private boolean dirty;

    public MagazineImpl(MagazineItem magazineItem) {
        this.magazineItem = magazineItem;
        this.size = new AtomicInteger(magazineItem.getSize());
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("size", this.size.get());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.size.set(nbt.m_128451_("size"));
    }

    @Override
    public float getArmorPenetration() {
        return this.magazineItem.getArmorPenetration();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public void setSize(int size) {
        this.dirty = true;
        this.size.set(size);
    }

    @Override
    public void refill() {
        this.dirty = true;
        this.size.set(this.magazineItem.getSize());
    }

    @Override
    public int decrementSize() {
        this.dirty = true;
        return this.size.decrementAndGet();
    }

    @Override
    public int getMaxSize() {
        return this.magazineItem.getSize();
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        out.m_130130_(this.size.get());
        this.dirty = false;
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        this.size.set(in.m_130242_());
    }

    @Override
    public boolean requiresSync() {
        return this.dirty;
    }
}

