/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.entity.ExplosionSource;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;

public class FireGrenadeEntity
extends Grenade
implements ExplosionSource {
    private static final BounceSound FIRE_GRENADE_BOUNCE_SOUND = new BounceSound(SoundEvents.f_11983_, 1.0f, 0.9f);

    public FireGrenadeEntity(EntityType<? extends Grenade> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public FireGrenadeEntity(Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.FIRE_GRENADE.get()), worldIn);
    }

    public FireGrenadeEntity(LivingEntity thrower, Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.FIRE_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public void onSurfaceHit(BlockHitResult blockRayTraceResult) {
        super.onSurfaceHit(blockRayTraceResult);
        if (blockRayTraceResult.m_82434_() == Direction.UP) {
            this.setActivated(true);
        }
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (activated && !this.f_19853_.m_5776_()) {
            this.m_6074_();
            float fireRadius = ((Double)ServerConfig.instance.explosivesFireGrenadeRadius.get()).floatValue();
            if (((Boolean)ServerConfig.instance.enableFireGrenadeSecondaryExplosion.get()).booleanValue()) {
                this.f_19853_.m_7703_((Entity)this, this.createDamageSource(), null, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), fireRadius, true, (Explosion.BlockInteraction)ServerConfig.instance.explosivesFireGrenadeExplosionMode.get());
            }
            BlockPos.m_121990_((BlockPos)this.m_142538_().m_142022_((double)(-fireRadius), 0.0, (double)(-fireRadius)), (BlockPos)this.m_142538_().m_142022_((double)fireRadius, 0.0, (double)fireRadius)).forEach(blockPos -> {
                if (this.f_19853_.m_8055_(blockPos).m_60795_() && Math.random() <= 0.8) {
                    this.f_19853_.m_46597_(blockPos, Blocks.f_50083_.m_49966_());
                }
            });
        }
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)((Object)ModItems.FIRE_GRENADE.get());
    }

    @Override
    public BounceSound getBounceSound(BlockHitResult blockRayTraceResult) {
        return blockRayTraceResult.m_82434_() == Direction.UP ? FIRE_GRENADE_BOUNCE_SOUND : super.getBounceSound(blockRayTraceResult);
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }

    @Override
    public float getDamageMultiplier() {
        return ((Double)ServerConfig.instance.explosivesFireGrenadeDamageMultiplier.get()).floatValue();
    }

    @Override
    public double getKnockbackMultiplier() {
        return (Double)ServerConfig.instance.explosivesFireGrenadeKnockbackMultiplier.get();
    }

    protected record BounceSound(SoundEvent soundEvent, float volume, float pitch) {
    }
}

