/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.action.ProgressBar;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.ModItems;
import java.util.Optional;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class EntityItemAction<T extends LivingExtension<?, ?>>
extends ItemAction {
    private final EntityItemActionType<T> type;
    private final LivingExtension<?, ?> performer;
    @Nullable
    private final T selectedTarget;

    protected EntityItemAction(InteractionHand hand, EntityItemActionType<T> type, LivingExtension<?, ?> performer, T selectedTarget) {
        super(hand);
        this.type = type;
        this.performer = performer;
        this.selectedTarget = selectedTarget;
    }

    public T getSelectedTarget() {
        return this.selectedTarget;
    }

    @Override
    public boolean start(boolean simulate) {
        return this.selectedTarget != null && super.start(simulate);
    }

    @Override
    public ActionObserver createPerformerObserver() {
        return ActionObserver.create(this, ProgressBar.create(this.type(), (Component)(this.performer == this.selectedTarget ? null : new TranslatableComponent("action.target", new Object[]{this.selectedTarget.entity().m_5446_().getString()})), this::getProgress));
    }

    @Override
    public ActionObserver createTargetObserver() {
        return ActionObserver.create(this, ProgressBar.create(this.type(), (Component)new TranslatableComponent("action.performer", new Object[]{this.performer.entity().m_5446_().getString()}), this::getProgress));
    }

    @Override
    public boolean tick() {
        EntityHitResult result;
        if (this.selectedTarget != this.performer && ((result = (EntityHitResult)RayTraceUtil.rayTraceEntities(this.performer.entity()).orElse(null)) == null || result.m_82443_() != this.selectedTarget.entity())) {
            this.performer.cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public void stop(Action.StopReason reason) {
        if (reason.isCompleted()) {
            if (this.type.getCustomAction() != null && this.performer.entity().m_21187_().nextFloat() < this.type.getCustomAction().chance()) {
                this.type.getCustomAction().consumer().accept(this.performer, (LivingExtension<?, ?>)this.selectedTarget);
            }
            this.selectedTarget.entity().curePotionEffects(this.getItemStack());
            this.applyMedicalEffects();
            for (EntityItemActionType.EffectAction action : this.type.getEffects()) {
                if (!(this.performer.entity().m_21187_().nextFloat() < action.chance())) continue;
                MobEffectInstance effectInstance = action.effect().get();
                if (effectInstance.m_19544_().m_8093_()) {
                    effectInstance.m_19544_().m_19461_(this.selectedTarget.entity(), this.selectedTarget.entity(), this.selectedTarget.entity(), effectInstance.m_19564_(), 1.0);
                    continue;
                }
                this.selectedTarget.entity().m_7292_(new MobEffectInstance(effectInstance));
            }
        }
        super.stop(reason);
    }

    @Override
    public LivingExtension<?, ?> performer() {
        return this.performer;
    }

    @Override
    public Optional<LivingExtension<?, ?>> target() {
        return this.selectedTarget == this.performer ? Optional.empty() : Optional.ofNullable(this.selectedTarget);
    }

    @Override
    public ItemActionType<?> type() {
        return this.type;
    }

    private void applyMedicalEffects() {
        ItemStack itemStack = this.getItemStack();
        Object targetEntity = this.selectedTarget.entity();
        Random random = this.performer.entity().m_21187_();
        if (itemStack.m_150930_((Item)ModItems.BANDAGE.get())) {
            float baseChance = ((Double)ServerConfig.instance.bandageBleedReductionChance.get()).floatValue();
            float effectiveChance = this.calculateBleedingChance((LivingEntity)targetEntity, baseChance);
            if (((Boolean)ServerConfig.instance.bandageRemovesBleeding.get()).booleanValue() && random.nextFloat() < effectiveChance) {
                targetEntity.m_21195_((MobEffect)ModMobEffects.BLEEDING.get());
            }
        } else if (itemStack.m_150930_((Item)ModItems.FIRST_AID_KIT.get())) {
            int severityReduction;
            ResourceLocation infectionEffectLocation;
            MobEffect infectionEffect;
            if (((Boolean)ServerConfig.instance.firstAidKitRemovesBleeding.get()).booleanValue()) {
                targetEntity.m_21195_((MobEffect)ModMobEffects.BLEEDING.get());
            }
            if ((infectionEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(infectionEffectLocation = new ResourceLocation("craftingdead", "infection"))) != null && targetEntity.m_21023_(infectionEffect) && random.nextFloat() < ((Double)ServerConfig.instance.firstAidKitInfectionReductionChance.get()).floatValue()) {
                targetEntity.m_21195_(infectionEffect);
            }
            if ((severityReduction = ((Integer)ServerConfig.instance.firstAidKitTraumaSeverityReduction.get()).intValue()) > 0) {
                this.reduceTraumaEffects((LivingEntity)targetEntity, severityReduction);
            }
        } else if (itemStack.m_150930_((Item)ModItems.CLEAN_RAG.get()) && ((Boolean)ServerConfig.instance.cleanRagRemovesBleeding.get()).booleanValue()) {
            targetEntity.m_21195_((MobEffect)ModMobEffects.BLEEDING.get());
        }
    }

    private float calculateBleedingChance(LivingEntity entity, float baseChance) {
        if (entity.m_21023_((MobEffect)ModMobEffects.ADRENALINE.get())) {
            float multiplier = ((Double)ServerConfig.instance.adrenalineBleedChanceMultiplier.get()).floatValue();
            return Math.min(1.0f, baseChance * multiplier);
        }
        return baseChance;
    }

    private void reduceTraumaEffects(LivingEntity entity, int levels) {
        MobEffectInstance slownessEffect;
        MobEffectInstance nauseaEffect;
        MobEffectInstance blindnessEffect = entity.m_21124_(MobEffects.f_19610_);
        if (blindnessEffect != null) {
            int newDuration = Math.max(1, blindnessEffect.m_19557_() - levels * 20);
            entity.m_21195_(MobEffects.f_19610_);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, newDuration, blindnessEffect.m_19564_()));
        }
        if ((nauseaEffect = entity.m_21124_(MobEffects.f_19604_)) != null) {
            int newDuration = Math.max(1, nauseaEffect.m_19557_() - levels * 40);
            entity.m_21195_(MobEffects.f_19604_);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, newDuration, nauseaEffect.m_19564_()));
        }
        if ((slownessEffect = entity.m_21124_(MobEffects.f_19597_)) != null) {
            int newDuration = Math.max(1, slownessEffect.m_19557_() - levels * 30);
            entity.m_21195_(MobEffects.f_19597_);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, newDuration, slownessEffect.m_19564_()));
        }
    }
}

